"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentListPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _services = require("../../../../../../common/services");
var _hooks = require("../../../hooks");
var _components = require("../../../components");
var _services2 = require("../../../services");
var _constants = require("../../../constants");
var _components2 = require("../components");
var _use_fleet_server_unhealthy = require("../hooks/use_fleet_server_unhealthy");
var _agent_request_diagnostics_modal = require("../components/agent_request_diagnostics_modal");
var _table_header = require("./components/table_header");
var _search_and_filter_bar = require("./components/search_and_filter_bar");
var _tags_add_remove = require("./components/tags_add_remove");
var _components3 = require("./components");
var _table_row_actions = require("./components/table_row_actions");
var _agent_list_table = require("./components/agent_list_table");
var _get_kuery = require("./utils/get_kuery");
var _hooks2 = require("./hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REFRESH_INTERVAL_MS = 30000;
const AgentListPage = () => {
  var _agentToAddRemoveTags;
  const {
    displayAgentMetrics
  } = _services2.ExperimentalFeaturesService.get();
  const {
    notifications,
    cloud
  } = (0, _hooks.useStartServices)();
  (0, _hooks.useBreadcrumbs)('agent_list');
  const defaultKuery = (0, _hooks.useUrlParams)().urlParams.kuery || '';

  // Agent data states
  const [showUpgradeable, setShowUpgradeable] = (0, _react.useState)(false);

  // Table and search states
  const [draftKuery, setDraftKuery] = (0, _react.useState)(defaultKuery);
  const [search, setSearch] = (0, _react.useState)(defaultKuery);
  const [selectionMode, setSelectionMode] = (0, _react.useState)('manual');
  const [selectedAgents, setSelectedAgents] = (0, _react.useState)([]);
  const tableRef = (0, _react.useRef)(null);
  const {
    pagination,
    pageSizeOptions,
    setPagination
  } = (0, _hooks.usePagination)();
  const [sortField, setSortField] = (0, _react.useState)('enrolled_at');
  const [sortOrder, setSortOrder] = (0, _react.useState)('desc');
  const VERSION_FIELD = 'local_metadata.elastic.agent.version';
  const HOSTNAME_FIELD = 'local_metadata.host.hostname';
  const onSubmitSearch = (0, _react.useCallback)(newKuery => {
    setSearch(newKuery);
    setPagination({
      ...pagination,
      currentPage: 1
    });
  }, [setSearch, pagination, setPagination]);

  // Policies state for filtering
  const [selectedAgentPolicies, setSelectedAgentPolicies] = (0, _react.useState)([]);

  // Status for filtering
  const [selectedStatus, setSelectedStatus] = (0, _react.useState)(['healthy', 'unhealthy', 'updating', 'offline']);
  const [selectedTags, setSelectedTags] = (0, _react.useState)([]);
  const isUsingFilter = !!(search.trim() || selectedAgentPolicies.length || selectedStatus.length || selectedTags.length || showUpgradeable);
  const clearFilters = (0, _react.useCallback)(() => {
    setDraftKuery('');
    setSearch('');
    setSelectedAgentPolicies([]);
    setSelectedStatus([]);
    setSelectedTags([]);
    setShowUpgradeable(false);
  }, [setSearch, setDraftKuery, setSelectedAgentPolicies, setSelectedStatus, setShowUpgradeable]);

  // Agent enrollment flyout state
  const [enrollmentFlyout, setEnrollmentFlyoutState] = (0, _react.useState)({
    isOpen: false
  });
  const [isAgentActivityFlyoutOpen, setAgentActivityFlyoutOpen] = (0, _react.useState)(false);
  const flyoutContext = (0, _hooks.useFlyoutContext)();

  // Agent actions states
  const [agentToReassign, setAgentToReassign] = (0, _react.useState)(undefined);
  const [agentToUnenroll, setAgentToUnenroll] = (0, _react.useState)(undefined);
  const [agentToGetUninstallCommand, setAgentToGetUninstallCommand] = (0, _react.useState)(undefined);
  const [agentToUpgrade, setAgentToUpgrade] = (0, _react.useState)(undefined);
  const [agentToAddRemoveTags, setAgentToAddRemoveTags] = (0, _react.useState)(undefined);
  const [tagsPopoverButton, setTagsPopoverButton] = (0, _react.useState)();
  const [showTagsAddRemove, setShowTagsAddRemove] = (0, _react.useState)(false);
  const [agentToRequestDiagnostics, setAgentToRequestDiagnostics] = (0, _react.useState)(undefined);
  const onTableChange = ({
    page,
    sort
  }) => {
    const newPagination = {
      ...pagination,
      currentPage: page.index + 1,
      pageSize: page.size
    };
    setPagination(newPagination);
    setSortField(sort.field);
    setSortOrder(sort.direction);
  };
  const showInactive = (0, _react.useMemo)(() => {
    return selectedStatus.some(status => status === 'inactive' || status === 'unenrolled');
  }, [selectedStatus]);

  // filters kuery
  const kuery = (0, _react.useMemo)(() => {
    return (0, _get_kuery.getKuery)({
      search,
      selectedAgentPolicies,
      selectedTags,
      selectedStatus
    });
  }, [search, selectedAgentPolicies, selectedStatus, selectedTags]);
  const [agentsOnCurrentPage, setAgentsOnCurrentPage] = (0, _react.useState)([]);
  const [agentsStatus, setAgentsStatus] = (0, _react.useState)();
  const [allTags, setAllTags] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [shownAgents, setShownAgents] = (0, _react.useState)(0);
  const [inactiveShownAgents, setInactiveShownAgents] = (0, _react.useState)(0);
  const [totalInactiveAgents, setTotalInactiveAgents] = (0, _react.useState)(0);
  const [totalManagedAgentIds, setTotalManagedAgentIds] = (0, _react.useState)([]);
  const [inactiveManagedAgentIds, setInactiveManagedAgentIds] = (0, _react.useState)([]);
  const [managedAgentsOnCurrentPage, setManagedAgentsOnCurrentPage] = (0, _react.useState)(0);
  const [showAgentActivityTour, setShowAgentActivityTour] = (0, _react.useState)({
    isOpen: false
  });
  const getSortFieldForAPI = field => {
    if ([VERSION_FIELD, HOSTNAME_FIELD].includes(field)) {
      return `${field}.keyword`;
    }
    return field;
  };
  const renderActions = agent => {
    const agentPolicy = typeof agent.policy_id === 'string' ? agentPoliciesIndexedById[agent.policy_id] : undefined;

    // refreshing agent tags passed to TagsAddRemove component
    if ((agentToAddRemoveTags === null || agentToAddRemoveTags === void 0 ? void 0 : agentToAddRemoveTags.id) === agent.id && !(0, _lodash.isEqual)(agent.tags, agentToAddRemoveTags.tags)) {
      setAgentToAddRemoveTags(agent);
    }
    return /*#__PURE__*/_react.default.createElement(_table_row_actions.TableRowActions, {
      agent: agent,
      agentPolicy: agentPolicy,
      onReassignClick: () => setAgentToReassign(agent),
      onUnenrollClick: () => setAgentToUnenroll(agent),
      onUpgradeClick: () => setAgentToUpgrade(agent),
      onAddRemoveTagsClick: button => {
        setTagsPopoverButton(button);
        setAgentToAddRemoveTags(agent);
        setShowTagsAddRemove(!showTagsAddRemove);
      },
      onGetUninstallCommandClick: () => setAgentToGetUninstallCommand(agent),
      onRequestDiagnosticsClick: () => setAgentToRequestDiagnostics(agent)
    });
  };
  const isLoadingVar = (0, _react.useRef)(false);

  // Request to fetch agents and agent status
  const currentRequestRef = (0, _react.useRef)(0);
  const fetchData = (0, _react.useCallback)(({
    refreshTags = false
  } = {}) => {
    async function fetchDataAsync() {
      // skipping refresh if previous request is in progress
      if (isLoadingVar.current) {
        return;
      }
      currentRequestRef.current++;
      const currentRequest = currentRequestRef.current;
      isLoadingVar.current = true;
      try {
        var _managedAgentPolicies, _managedAgentPolicies2;
        setIsLoading(true);
        const [agentsResponse, totalInactiveAgentsResponse, managedAgentPoliciesResponse, agentTagsResponse] = await Promise.all([(0, _hooks.sendGetAgents)({
          page: pagination.currentPage,
          perPage: pagination.pageSize,
          kuery: kuery && kuery !== '' ? kuery : undefined,
          sortField: getSortFieldForAPI(sortField),
          sortOrder,
          showInactive,
          showUpgradeable,
          getStatusSummary: true,
          withMetrics: displayAgentMetrics
        }), (0, _hooks.sendGetAgentStatus)({
          kuery: _services2.AgentStatusKueryHelper.buildKueryForInactiveAgents()
        }), (0, _hooks.sendGetAgentPolicies)({
          kuery: `${_constants.AGENT_POLICY_SAVED_OBJECT_TYPE}.is_managed:true`,
          perPage: _constants.SO_SEARCH_LIMIT,
          full: false
        }), (0, _hooks.sendGetAgentTags)({
          kuery: kuery && kuery !== '' ? kuery : undefined,
          showInactive
        })]);
        isLoadingVar.current = false;
        // Return if a newer request has been triggered
        if (currentRequestRef.current !== currentRequest) {
          return;
        }
        if (agentsResponse.error) {
          throw agentsResponse.error;
        }
        if (!agentsResponse.data) {
          throw new Error('Invalid GET /agents response');
        }
        if (!totalInactiveAgentsResponse.data) {
          throw new Error('Invalid GET /agents_status response');
        }
        if (managedAgentPoliciesResponse.error) {
          throw new Error(managedAgentPoliciesResponse.error.message);
        }
        if (agentTagsResponse.error) {
          throw agentTagsResponse.error;
        }
        if (!agentTagsResponse.data) {
          throw new Error('Invalid GET /agent/tags response');
        }
        const statusSummary = agentsResponse.data.statusSummary;
        if (!statusSummary) {
          throw new Error('Invalid GET /agents response - no status summary');
        }
        setAgentsStatus((0, _services.agentStatusesToSummary)(statusSummary));
        const newAllTags = agentTagsResponse.data.items;
        // We only want to update the list of available tags if
        // - We haven't set any tags yet
        // - We've received the "refreshTags" flag which will force a refresh of the tags list when an agent is unenrolled
        // - Tags are modified (add, remove, edit)
        if (!allTags || refreshTags || !(0, _lodash.isEqual)(newAllTags, allTags)) {
          setAllTags(newAllTags);
        }
        setAgentsOnCurrentPage(agentsResponse.data.items);
        setShownAgents(agentsResponse.data.total);
        setTotalInactiveAgents(totalInactiveAgentsResponse.data.results.inactive || 0);
        setInactiveShownAgents(showInactive ? totalInactiveAgentsResponse.data.results.inactive || 0 : 0);
        const managedAgentPolicies = (_managedAgentPolicies = (_managedAgentPolicies2 = managedAgentPoliciesResponse.data) === null || _managedAgentPolicies2 === void 0 ? void 0 : _managedAgentPolicies2.items) !== null && _managedAgentPolicies !== void 0 ? _managedAgentPolicies : [];
        if (managedAgentPolicies.length === 0) {
          setTotalManagedAgentIds([]);
          setManagedAgentsOnCurrentPage(0);
        } else {
          var _response$data$items, _response$data;
          // Find all the agents that have managed policies and are not unenrolled
          const policiesKuery = managedAgentPolicies.map(policy => `policy_id:"${policy.id}"`).join(' or ');
          const response = await (0, _hooks.sendGetAgents)({
            kuery: `NOT (status:unenrolled) and ${policiesKuery}`,
            perPage: _constants.SO_SEARCH_LIMIT,
            showInactive: true
          });
          if (response.error) {
            throw new Error(response.error.message);
          }
          const allManagedAgents = (_response$data$items = (_response$data = response.data) === null || _response$data === void 0 ? void 0 : _response$data.items) !== null && _response$data$items !== void 0 ? _response$data$items : [];
          const allManagedAgentIds = allManagedAgents === null || allManagedAgents === void 0 ? void 0 : allManagedAgents.map(agent => agent.id);
          const inactiveManagedIds = allManagedAgents === null || allManagedAgents === void 0 ? void 0 : allManagedAgents.filter(agent => agent.status === 'inactive').map(agent => agent.id);
          setTotalManagedAgentIds(allManagedAgentIds);
          setInactiveManagedAgentIds(inactiveManagedIds);
          setManagedAgentsOnCurrentPage(agentsResponse.data.items.map(agent => agent.id).filter(agentId => allManagedAgentIds.includes(agentId)).length);
        }
      } catch (error) {
        notifications.toasts.addError(error, {
          title: _i18n.i18n.translate('xpack.fleet.agentList.errorFetchingDataTitle', {
            defaultMessage: 'Error fetching agents'
          })
        });
      }
      setIsLoading(false);
    }
    fetchDataAsync();
  }, [pagination.currentPage, pagination.pageSize, kuery, sortField, sortOrder, showInactive, showUpgradeable, displayAgentMetrics, allTags, notifications.toasts]);

  // Send request to get agent list and status
  (0, _react.useEffect)(() => {
    fetchData();
    const interval = setInterval(() => {
      fetchData();
    }, REFRESH_INTERVAL_MS);
    return () => clearInterval(interval);
  }, [fetchData]);
  const agentPoliciesRequest = (0, _hooks.useGetAgentPolicies)({
    page: 1,
    perPage: _constants.SO_SEARCH_LIMIT,
    full: true
  });
  const agentPolicies = (0, _react.useMemo)(() => agentPoliciesRequest.data ? agentPoliciesRequest.data.items : [], [agentPoliciesRequest]);
  const agentPoliciesIndexedById = (0, _react.useMemo)(() => {
    return agentPolicies.reduce((acc, agentPolicy) => {
      acc[agentPolicy.id] = agentPolicy;
      return acc;
    }, {});
  }, [agentPolicies]);
  const isAgentSelectable = (0, _react.useCallback)(agent => {
    if (!agent.active) return false;
    if (!agent.policy_id) return true;
    const agentPolicy = agentPoliciesIndexedById[agent.policy_id];
    const isHosted = (agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.is_managed) === true;
    return !isHosted;
  }, [agentPoliciesIndexedById]);
  const onSelectionChange = newAgents => {
    setSelectedAgents(newAgents);
    if (selectionMode === 'query' && newAgents.length < selectedAgents.length) {
      // differentiating between selection changed by agents dropping from current page or user action
      const areSelectedAgentsStillVisible = selectedAgents.length > 0 && (0, _lodash.differenceBy)(selectedAgents, agentsOnCurrentPage, 'id').length === 0;
      if (areSelectedAgentsStillVisible) {
        setSelectionMode('manual');
      } else {
        // force selecting all agents on current page if staying in query mode
        if (tableRef !== null && tableRef !== void 0 && tableRef.current) {
          tableRef.current.setSelection(agentsOnCurrentPage);
        }
      }
    }
  };
  const agentToUnenrollHasFleetServer = (0, _react.useMemo)(() => {
    if (!agentToUnenroll || !agentToUnenroll.policy_id) {
      return false;
    }
    const agentPolicy = agentPoliciesIndexedById[agentToUnenroll.policy_id];
    if (!agentPolicy) {
      return false;
    }
    return (0, _services2.policyHasFleetServer)(agentPolicy);
  }, [agentToUnenroll, agentPoliciesIndexedById]);

  // Missing Encryption key
  const [canShowMissingEncryptionKeyCallout, dismissEncryptionKeyCallout] = (0, _hooks2.useMissingEncryptionKeyCallout)();

  // Fleet server unhealthy status
  const {
    isUnhealthy: isFleetServerUnhealthy
  } = (0, _use_fleet_server_unhealthy.useFleetServerUnhealthy)();
  const {
    isFleetServerStandalone
  } = (0, _hooks.useFleetServerStandalone)();
  const showUnhealthyCallout = isFleetServerUnhealthy && !isFleetServerStandalone;
  const {
    shouldDisplayAgentSoftLimit
  } = (0, _hooks2.useAgentSoftLimit)();
  const onClickAddFleetServer = (0, _react.useCallback)(() => {
    flyoutContext.openFleetServerFlyout();
  }, [flyoutContext]);
  const onClickAgentActivity = (0, _react.useCallback)(() => {
    setAgentActivityFlyoutOpen(true);
  }, [setAgentActivityFlyoutOpen]);
  const refreshAgents = ({
    refreshTags = false
  } = {}) => {
    fetchData({
      refreshTags
    });
    setShowAgentActivityTour({
      isOpen: true
    });
  };
  const isCurrentRequestIncremented = (currentRequestRef === null || currentRequestRef === void 0 ? void 0 : currentRequestRef.current) === 1;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isAgentActivityFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components3.AgentActivityFlyout, {
    onAbortSuccess: fetchData,
    onClose: () => setAgentActivityFlyoutOpen(false),
    refreshAgentActivity: isLoading,
    setSearch: setSearch,
    setSelectedStatus: setSelectedStatus
  })) : null, enrollmentFlyout.isOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components.AgentEnrollmentFlyout, {
    agentPolicy: agentPolicies.find(p => p.id === enrollmentFlyout.selectedPolicyId),
    onClose: () => {
      setEnrollmentFlyoutState({
        isOpen: false
      });
      fetchData();
      agentPoliciesRequest.resendRequest();
    }
  })) : null, agentToReassign && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components2.AgentReassignAgentPolicyModal, {
    agents: [agentToReassign],
    onClose: () => {
      setAgentToReassign(undefined);
      refreshAgents();
    }
  })), agentToUnenroll && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components2.AgentUnenrollAgentModal, {
    agents: [agentToUnenroll],
    agentCount: 1,
    onClose: () => {
      setAgentToUnenroll(undefined);
      refreshAgents({
        refreshTags: true
      });
    },
    useForceUnenroll: agentToUnenroll.status === 'unenrolling',
    hasFleetServer: agentToUnenrollHasFleetServer
  })), (agentToGetUninstallCommand === null || agentToGetUninstallCommand === void 0 ? void 0 : agentToGetUninstallCommand.policy_id) && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components.UninstallCommandFlyout, {
    target: "agent",
    policyId: agentToGetUninstallCommand.policy_id,
    onClose: () => {
      setAgentToGetUninstallCommand(undefined);
      refreshAgents({
        refreshTags: true
      });
    }
  })), agentToUpgrade && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_components2.AgentUpgradeAgentModal, {
    agents: [agentToUpgrade],
    agentCount: 1,
    onClose: () => {
      setAgentToUpgrade(undefined);
      refreshAgents();
    },
    isUpdating: Boolean(agentToUpgrade.upgrade_started_at && !agentToUpgrade.upgraded_at)
  })), agentToRequestDiagnostics && /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_agent_request_diagnostics_modal.AgentRequestDiagnosticsModal, {
    agents: [agentToRequestDiagnostics],
    agentCount: 1,
    onClose: () => {
      setAgentToRequestDiagnostics(undefined);
    }
  })), showTagsAddRemove && /*#__PURE__*/_react.default.createElement(_tags_add_remove.TagsAddRemove, {
    agentId: agentToAddRemoveTags === null || agentToAddRemoveTags === void 0 ? void 0 : agentToAddRemoveTags.id,
    allTags: allTags !== null && allTags !== void 0 ? allTags : [],
    selectedTags: (_agentToAddRemoveTags = agentToAddRemoveTags === null || agentToAddRemoveTags === void 0 ? void 0 : agentToAddRemoveTags.tags) !== null && _agentToAddRemoveTags !== void 0 ? _agentToAddRemoveTags : [],
    button: tagsPopoverButton,
    onTagsUpdated: () => {
      refreshAgents();
    },
    onClosePopover: () => {
      setShowTagsAddRemove(false);
    }
  }), showUnhealthyCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, cloud !== null && cloud !== void 0 && cloud.deploymentUrl ? /*#__PURE__*/_react.default.createElement(_components2.FleetServerCloudUnhealthyCallout, {
    deploymentUrl: cloud.deploymentUrl
  }) : /*#__PURE__*/_react.default.createElement(_components2.FleetServerOnPremUnhealthyCallout, {
    onClickAddFleetServer: onClickAddFleetServer
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), canShowMissingEncryptionKeyCallout && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components2.FleetServerMissingEncryptionKeyCallout, {
    onClickHandler: dismissEncryptionKeyCallout
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), shouldDisplayAgentSoftLimit && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_components3.AgentSoftLimitCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(_search_and_filter_bar.SearchAndFilterBar, {
    agentPolicies: agentPolicies,
    draftKuery: draftKuery,
    onDraftKueryChange: setDraftKuery,
    onSubmitSearch: onSubmitSearch,
    selectedAgentPolicies: selectedAgentPolicies,
    onSelectedAgentPoliciesChange: setSelectedAgentPolicies,
    selectedStatus: selectedStatus,
    onSelectedStatusChange: setSelectedStatus,
    showUpgradeable: showUpgradeable,
    onShowUpgradeableChange: setShowUpgradeable,
    tags: allTags !== null && allTags !== void 0 ? allTags : [],
    selectedTags: selectedTags,
    onSelectedTagsChange: setSelectedTags,
    shownAgents: shownAgents,
    inactiveShownAgents: inactiveShownAgents,
    totalInactiveAgents: totalInactiveAgents,
    totalManagedAgentIds: totalManagedAgentIds,
    inactiveManagedAgentIds: inactiveManagedAgentIds,
    selectionMode: selectionMode,
    currentQuery: kuery,
    selectedAgents: selectedAgents,
    refreshAgents: refreshAgents,
    onClickAddAgent: () => setEnrollmentFlyoutState({
      isOpen: true
    }),
    onClickAddFleetServer: onClickAddFleetServer,
    visibleAgents: agentsOnCurrentPage,
    onClickAgentActivity: onClickAgentActivity,
    showAgentActivityTour: showAgentActivityTour
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_table_header.AgentTableHeader, {
    showInactive: showInactive,
    totalAgents: shownAgents,
    agentStatus: agentsStatus,
    selectableAgents: (agentsOnCurrentPage === null || agentsOnCurrentPage === void 0 ? void 0 : agentsOnCurrentPage.filter(isAgentSelectable).length) || 0,
    managedAgentsOnCurrentPage: managedAgentsOnCurrentPage,
    selectionMode: selectionMode,
    setSelectionMode: setSelectionMode,
    selectedAgents: selectedAgents,
    setSelectedAgents: newAgents => {
      if (tableRef !== null && tableRef !== void 0 && tableRef.current) {
        tableRef.current.setSelection(newAgents);
        setSelectionMode('manual');
      }
    },
    clearFilters: clearFilters,
    isUsingFilter: isUsingFilter
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_agent_list_table.AgentListTable, {
    agents: agentsOnCurrentPage,
    sortField: sortField,
    pageSizeOptions: pageSizeOptions,
    sortOrder: sortOrder,
    isLoading: isLoading,
    agentPoliciesIndexedById: agentPoliciesIndexedById,
    renderActions: renderActions,
    onSelectionChange: onSelectionChange,
    tableRef: tableRef,
    showUpgradeable: showUpgradeable,
    onTableChange: onTableChange,
    pagination: pagination,
    totalAgents: Math.min(shownAgents, _constants.SO_SEARCH_LIMIT),
    isUsingFilter: isUsingFilter,
    setEnrollmentFlyoutState: setEnrollmentFlyoutState,
    clearFilters: clearFilters,
    isCurrentRequestIncremented: isCurrentRequestIncremented
  }));
};
exports.AgentListPage = AgentListPage;