"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useInactiveAgentsCalloutHasBeenDismissed = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOCAL_STORAGE_KEY = 'fleet.inactiveAgentsCalloutHasBeenDismissed';
const useInactiveAgentsCalloutHasBeenDismissed = () => {
  const [inactiveAgentsCalloutHasBeenDismissed, setInactiveAgentsCalloutHasBeenDismissed] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const storageValue = localStorage.getItem(LOCAL_STORAGE_KEY);
    if (storageValue) {
      setInactiveAgentsCalloutHasBeenDismissed(Boolean(storageValue));
    }
  }, []);
  const updateInactiveAgentsCalloutHasBeenDismissed = newValue => {
    localStorage.setItem(LOCAL_STORAGE_KEY, newValue.toString());
    setInactiveAgentsCalloutHasBeenDismissed(newValue);
  };
  return [inactiveAgentsCalloutHasBeenDismissed, updateInactiveAgentsCalloutHasBeenDismissed];
};
exports.useInactiveAgentsCalloutHasBeenDismissed = useInactiveAgentsCalloutHasBeenDismissed;