"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UpgradeInProgressActivityItem = exports.AgentActivityFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _hooks = require("../hooks");
var _hooks2 = require("../../../../hooks");
var _constants = require("../../../../constants");
var _components = require("../../components");
var _get_kuery = require("../utils/get_kuery");
var _agent_status = require("../../services/agent_status");
var _agent_activity_helper = require("./agent_activity_helper");
var _view_errors = require("./view_errors");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FullHeightFlyoutBody = (0, _styledComponents.default)(_eui.EuiFlyoutBody)`
  .euiFlyoutBody__overflowContent {
    height: 100%;
  }
`;
const FlyoutFooterWPadding = (0, _styledComponents.default)(_eui.EuiFlyoutFooter)`
  padding: 16px 24px !important;
`;
const MAX_VIEW_AGENTS_COUNT = 1000;
const AgentActivityFlyout = ({
  onClose,
  onAbortSuccess,
  refreshAgentActivity,
  setSearch,
  setSelectedStatus
}) => {
  const {
    notifications
  } = (0, _hooks2.useStartServices)();
  const {
    data: agentPoliciesData
  } = (0, _hooks2.useGetAgentPolicies)({
    perPage: _constants.SO_SEARCH_LIMIT
  });
  const {
    currentActions,
    abortUpgrade,
    isFirstLoading
  } = (0, _hooks.useActionStatus)(onAbortSuccess, refreshAgentActivity);
  const getAgentPolicyName = policyId => {
    var _policy$name;
    const policy = agentPoliciesData === null || agentPoliciesData === void 0 ? void 0 : agentPoliciesData.items.find(item => item.id === policyId);
    return (_policy$name = policy === null || policy === void 0 ? void 0 : policy.name) !== null && _policy$name !== void 0 ? _policy$name : policyId;
  };
  const currentActionsEnriched = currentActions.map(a => {
    var _a$newPolicyId, _a$policyId;
    return {
      ...a,
      newPolicyId: getAgentPolicyName((_a$newPolicyId = a.newPolicyId) !== null && _a$newPolicyId !== void 0 ? _a$newPolicyId : ''),
      policyId: getAgentPolicyName((_a$policyId = a.policyId) !== null && _a$policyId !== void 0 ? _a$policyId : '')
    };
  });
  const inProgressActions = currentActionsEnriched.filter(a => a.status === 'IN_PROGRESS');
  const completedActions = currentActionsEnriched.filter(a => a.status !== 'IN_PROGRESS');
  const todayActions = (0, _agent_activity_helper.getTodayActions)(completedActions);
  const otherDays = (0, _agent_activity_helper.getOtherDaysActions)(completedActions);
  const onClickViewAgents = async action => {
    try {
      var _data$items;
      const {
        data
      } = await (0, _hooks2.sendPostRetrieveAgentsByActions)({
        actionIds: [action.actionId]
      });
      if (data !== null && data !== void 0 && (_data$items = data.items) !== null && _data$items !== void 0 && _data$items.length) {
        const kuery = (0, _get_kuery.getKuery)({
          selectedAgentIds: data.items
        });
        setSearch(kuery);
      }
      setSelectedStatus(_agent_status.AGENT_STATUSES);
      onClose();
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.fleet.agentActivityFlyout.error', {
          defaultMessage: 'Error viewing selected agents'
        })
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "agentActivityFlyout",
    onClose: onClose,
    size: "m",
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    "aria-labelledby": "FleetAgentActivityFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l"
  }, /*#__PURE__*/_react.default.createElement("h1", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.title",
    defaultMessage: "Agent activity"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.activityLogText",
    defaultMessage: "Activity log of Elastic Agent operations will appear here."
  }))))))), /*#__PURE__*/_react.default.createElement(FullHeightFlyoutBody, null, isFirstLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: 'center',
    alignItems: 'center',
    className: "eui-fullHeight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_components.Loading, null))) : currentActionsEnriched.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: 'center',
    alignItems: 'center',
    className: "eui-fullHeight"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "clock",
    iconColor: "default",
    title: /*#__PURE__*/_react.default.createElement("h2", null, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityFlyout.noActivityText",
      defaultMessage: "No activity to display"
    })),
    titleSize: "m",
    body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityFlyout.noActivityDescription",
      defaultMessage: "Activity feed will appear here as agents are reassigned, upgraded, or unenrolled."
    })
  }))) : null, inProgressActions.length > 0 ? /*#__PURE__*/_react.default.createElement(ActivitySection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityFlyout.inProgressTitle",
      defaultMessage: "In progress"
    }),
    actions: inProgressActions,
    abortUpgrade: abortUpgrade,
    onClickViewAgents: onClickViewAgents
  }) : null, todayActions.length > 0 ? /*#__PURE__*/_react.default.createElement(ActivitySection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityFlyout.todayTitle",
      defaultMessage: "Today"
    }),
    actions: todayActions,
    abortUpgrade: abortUpgrade,
    onClickViewAgents: onClickViewAgents
  }) : null, Object.keys(otherDays).map(day => /*#__PURE__*/_react.default.createElement(ActivitySection, {
    key: day,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
      value: day,
      year: "numeric",
      month: "short",
      day: "2-digit"
    }),
    actions: otherDays[day],
    abortUpgrade: abortUpgrade,
    onClickViewAgents: onClickViewAgents
  }))), /*#__PURE__*/_react.default.createElement(FlyoutFooterWPadding, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.closeBtn",
    defaultMessage: "Close"
  }))))))));
};
exports.AgentActivityFlyout = AgentActivityFlyout;
const ActivitySection = ({
  title,
  actions,
  abortUpgrade,
  onClickViewAgents
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued",
    hasBorder: true,
    borderRadius: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("b", null, title))), actions.map(currentAction => currentAction.type === 'UPGRADE' && currentAction.status === 'IN_PROGRESS' ? /*#__PURE__*/_react.default.createElement(UpgradeInProgressActivityItem, {
    action: currentAction,
    abortUpgrade: abortUpgrade,
    key: currentAction.actionId,
    onClickViewAgents: onClickViewAgents
  }) : /*#__PURE__*/_react.default.createElement(ActivityItem, {
    action: currentAction,
    key: currentAction.actionId,
    onClickViewAgents: onClickViewAgents
  })));
};
const actionNames = {
  POLICY_REASSIGN: {
    inProgressText: 'Reassigning',
    completedText: 'assigned to a new policy',
    cancelledText: 'assignment'
  },
  UPGRADE: {
    inProgressText: 'Upgrading',
    completedText: 'upgraded',
    cancelledText: 'upgrade'
  },
  UNENROLL: {
    inProgressText: 'Unenrolling',
    completedText: 'unenrolled',
    cancelledText: 'unenrollment'
  },
  FORCE_UNENROLL: {
    inProgressText: 'Force unenrolling',
    completedText: 'force unenrolled',
    cancelledText: 'force unenrollment'
  },
  UPDATE_TAGS: {
    inProgressText: 'Updating tags of',
    completedText: 'updated tags',
    cancelledText: 'update tags'
  },
  CANCEL: {
    inProgressText: 'Cancelling',
    completedText: 'cancelled',
    cancelledText: ''
  },
  REQUEST_DIAGNOSTICS: {
    inProgressText: 'Requesting diagnostics for',
    completedText: 'requested diagnostics',
    cancelledText: 'request diagnostics'
  },
  SETTINGS: {
    inProgressText: 'Updating settings of',
    completedText: 'updated settings',
    cancelledText: 'update settings'
  },
  POLICY_CHANGE: {
    inProgressText: 'Applying policy change on',
    completedText: 'applied policy change',
    cancelledText: 'policy change'
  },
  INPUT_ACTION: {
    inProgressText: 'Input action in progress of',
    completedText: 'input action completed',
    cancelledText: 'input action'
  },
  ACTION: {
    inProgressText: 'Actioning',
    completedText: 'actioned',
    cancelledText: 'action'
  }
};
const getAction = type => {
  var _actionNames;
  return (_actionNames = actionNames[type !== null && type !== void 0 ? type : 'ACTION']) !== null && _actionNames !== void 0 ? _actionNames : actionNames.ACTION;
};
const inProgressTitleColor = '#0077CC';
const formattedTime = time => {
  return time ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
    value: time,
    year: "numeric",
    month: "short",
    day: "2-digit"
  }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedTime, {
    value: time
  })) : null;
};
const inProgressTitle = action => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.agentActivity.inProgressTitle",
  defaultMessage: "{inProgressText} {nbAgents} {agents} {reassignText}{upgradeText}{failuresText}",
  values: {
    nbAgents: action.nbAgentsAck >= action.nbAgentsActioned ? action.nbAgentsAck : action.nbAgentsAck === 0 ? action.nbAgentsActioned : action.nbAgentsActioned - action.nbAgentsAck + ' of ' + action.nbAgentsActioned,
    agents: action.nbAgentsActioned === 1 ? 'agent' : 'agents',
    inProgressText: getAction(action.type).inProgressText,
    reassignText: action.type === 'POLICY_REASSIGN' && action.newPolicyId ? `to ${action.newPolicyId}` : '',
    upgradeText: action.type === 'UPGRADE' ? `to version ${action.version}` : '',
    failuresText: action.nbAgentsFailed > 0 ? `, has ${action.nbAgentsFailed} failure(s)` : ''
  }
});
const inProgressDescription = time => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.agentActivityFlyout.startedDescription",
  defaultMessage: "Started on {date}.",
  values: {
    date: formattedTime(time)
  }
});
const ActivityItem = ({
  action,
  onClickViewAgents
}) => {
  const completeTitle = action.type === 'POLICY_CHANGE' && action.nbAgentsActioned === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivity.policyChangeCompletedTitle",
    defaultMessage: "Policy changed"
  })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivity.completedTitle",
    defaultMessage: "{nbAgents} {agents} {completedText}{offlineText}",
    values: {
      nbAgents: action.nbAgentsAck === action.nbAgentsActioned ? action.nbAgentsAck : action.nbAgentsAck + ' of ' + action.nbAgentsActioned,
      agents: action.nbAgentsActioned === 1 ? 'agent' : 'agents',
      completedText: getAction(action.type).completedText,
      offlineText: action.status === 'ROLLOUT_PASSED' && action.nbAgentsActioned - action.nbAgentsAck > 0 ? `, ${action.nbAgentsActioned - action.nbAgentsAck} agent(s) offline during the rollout period` : ''
    }
  }));
  const completedDescription = /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.completedDescription",
    defaultMessage: "Completed {date}",
    values: {
      date: formattedTime(action.completionTime)
    }
  });
  const failedDescription = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.failureDescription",
    defaultMessage: "A problem occurred during this operation."
  }), "\xA0", inProgressDescription(action.creationTime)));
  const displayByStatus = {
    IN_PROGRESS: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m"
      }),
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, inProgressTitle(action)),
      titleColor: inProgressTitleColor,
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, inProgressDescription(action.creationTime))
    },
    ROLLOUT_PASSED: {
      icon: action.nbAgentsFailed > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "warning",
        color: "red"
      }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "checkInCircleFilled",
        color: "green"
      }),
      title: completeTitle,
      titleColor: action.nbAgentsFailed > 0 ? 'red' : 'green',
      description: action.nbAgentsFailed > 0 ? failedDescription : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, completedDescription)
    },
    COMPLETE: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "checkInCircleFilled",
        color: "green"
      }),
      title: completeTitle,
      titleColor: 'green',
      description: action.type === 'POLICY_REASSIGN' && action.newPolicyId ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.reassignCompletedDescription",
        defaultMessage: "Assigned to {policy}.",
        values: {
          policy: action.newPolicyId
        }
      }), ' ', completedDescription)) : action.type === 'POLICY_CHANGE' ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("b", null, action.policyId), ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.policyChangedDescription",
        defaultMessage: "changed to revision {rev} at {date}.",
        values: {
          rev: action.revision,
          date: formattedTime(action.creationTime)
        }
      }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, completedDescription)
    },
    FAILED: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "warning",
        color: "red"
      }),
      title: completeTitle,
      titleColor: 'red',
      description: failedDescription
    },
    CANCELLED: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "warning",
        color: "grey"
      }),
      titleColor: 'grey',
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.cancelledTitle",
        defaultMessage: "Agent {cancelledText} cancelled",
        values: {
          cancelledText: getAction(action.type).cancelledText
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.cancelledDescription",
        defaultMessage: "Cancelled on {date}",
        values: {
          date: formattedTime(action.cancellationTime)
        }
      }))
    },
    EXPIRED: {
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "warning",
        color: "grey"
      }),
      titleColor: 'grey',
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.expiredTitle",
        defaultMessage: "Agent {expiredText} expired",
        values: {
          expiredText: getAction(action.type).cancelledText
        }
      })),
      description: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.expiredDescription",
        defaultMessage: "Expired on {date}",
        values: {
          date: formattedTime(action.expiration)
        }
      }))
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    borderRadius: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, displayByStatus[action.status].icon), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: displayByStatus[action.status].titleColor,
    "data-test-subj": "statusTitle"
  }, displayByStatus[action.status].title)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "statusDescription"
  }, displayByStatus[action.status].description)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, action.status === 'FAILED' && action.latestErrors && action.latestErrors.length > 0 ? /*#__PURE__*/_react.default.createElement(_view_errors.ViewErrors, {
    action: action
  }) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(ViewAgentsButton, {
    action: action,
    onClickViewAgents: onClickViewAgents
  }));
};
const UpgradeInProgressActivityItem = ({
  action,
  abortUpgrade,
  onClickViewAgents
}) => {
  const {
    docLinks
  } = (0, _hooks2.useStartServices)();
  const [isAborting, setIsAborting] = (0, _react.useState)(false);
  const onClickAbortUpgrade = (0, _react.useCallback)(async () => {
    try {
      setIsAborting(true);
      await abortUpgrade(action);
    } finally {
      setIsAborting(false);
    }
  }, [action, abortUpgrade]);
  const isScheduled = (0, _react.useMemo)(() => {
    if (!action.startTime) {
      return false;
    }
    const now = Date.now();
    const startDate = new Date(action.startTime).getTime();
    return startDate > now;
  }, [action]);
  const showCancelButton = (0, _react.useMemo)(() => {
    return isScheduled || action.hasRolloutPeriod;
  }, [action, isScheduled]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    borderRadius: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isScheduled ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "clock"
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: inProgressTitleColor,
    "data-test-subj": "upgradeInProgressTitle"
  }, isScheduled && action.startTime ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.scheduleTitle",
    defaultMessage: "{nbAgents} agents scheduled to upgrade to version {version}",
    values: {
      nbAgents: action.nbAgentsActioned - action.nbAgentsAck,
      version: action.version
    }
  }) : inProgressTitle(action))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    "data-test-subj": "upgradeInProgressDescription"
  }, /*#__PURE__*/_react.default.createElement("p", null, isScheduled && action.startTime ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.scheduledDescription",
    defaultMessage: "Scheduled for "
  }), /*#__PURE__*/_react.default.createElement("strong", null, formattedTime(action.startTime)), ".\xA0") : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, inProgressDescription(action.creationTime), "\xA0"), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.upgradeDescription",
    defaultMessage: "{guideLink} about agent upgrades.",
    values: {
      guideLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.upgradeElasticAgent,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.agentActivityFlyout.guideLink",
        defaultMessage: "Learn more"
      }))
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(ViewAgentsButton, {
    action: action,
    onClickViewAgents: onClickViewAgents
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, showCancelButton ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    onClick: onClickAbortUpgrade,
    isLoading: isAborting,
    "data-test-subj": "abortBtn"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.abortUpgradeButtom",
    defaultMessage: "Cancel"
  })) : null)))));
};
exports.UpgradeInProgressActivityItem = UpgradeInProgressActivityItem;
const ViewAgentsButton = ({
  action,
  onClickViewAgents
}) => {
  if (action.type === 'UPDATE_TAGS') {
    return null;
  }
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "m",
    onClick: () => onClickViewAgents(action),
    flush: "left",
    "data-test-subj": "agentActivityFlyout.viewAgentsButton",
    disabled: action.nbAgentsActionCreated > MAX_VIEW_AGENTS_COUNT
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.agentActivityFlyout.viewAgentsButton",
    defaultMessage: "View Agents"
  }));
  if (action.nbAgentsActionCreated <= MAX_VIEW_AGENTS_COUNT) {
    return button;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.agentActivityFlyout.viewAgentsButtonDisabledMaxTooltip",
      defaultMessage: "The view agents feature is only available for action impacting less then {agentCount} agents",
      values: {
        agentCount: MAX_VIEW_AGENTS_COUNT
      }
    })
  }, button);
};