"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderRightContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _reactRouterDom = require("react-router-dom");
var _eui = require("@elastic/eui");
var _hooks = require("../../../../../hooks");
var _components = require("../../../components");
var _components2 = require("../../../../../components");
var _constants = require("../../../../../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Divider = _styledComponents.default.div`
  width: 0;
  height: 100%;
  border-left: ${props => props.theme.eui.euiBorderThin};
`;
const HeaderRightContent = ({
  isLoading,
  policyId,
  agentPolicy,
  agentStatus,
  addAgent,
  onCancelEnrollment,
  isAddAgentHelpPopoverOpen,
  setIsAddAgentHelpPopoverOpen
}) => {
  var _agentPolicy$revision;
  const {
    getPath
  } = (0, _hooks.useLink)();
  const history = (0, _reactRouterDom.useHistory)();
  const isFleetServerPolicy = (0, _react.useMemo)(() => {
    var _agentPolicy$package_;
    return agentPolicy === null || agentPolicy === void 0 ? void 0 : (_agentPolicy$package_ = agentPolicy.package_policies) === null || _agentPolicy$package_ === void 0 ? void 0 : _agentPolicy$package_.some(packagePolicy => {
      var _packagePolicy$packag;
      return ((_packagePolicy$packag = packagePolicy.package) === null || _packagePolicy$packag === void 0 ? void 0 : _packagePolicy$packag.name) === _constants.FLEET_SERVER_PACKAGE;
    });
  }, [agentPolicy]);
  if (!agentPolicy) {
    return null;
  }
  const addAgentLink = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: addAgent,
    "data-test-subj": "addAgentLink"
  }, isFleetServerPolicy ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.addFleetServerButton",
    defaultMessage: "Add Fleet Server"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.policyDetails.addAgentButton",
    defaultMessage: "Add agent"
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'flexEnd',
    direction: "row"
  }, [{
    label: _i18n.i18n.translate('xpack.fleet.policyDetails.summary.revision', {
      defaultMessage: 'Revision'
    }),
    content: (_agentPolicy$revision = agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.revision) !== null && _agentPolicy$revision !== void 0 ? _agentPolicy$revision : 0
  }, {
    isDivider: true
  }, {
    label: _i18n.i18n.translate('xpack.fleet.policyDetails.summary.integrations', {
      defaultMessage: 'Integrations'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiI18nNumber, {
      value: agentPolicy && agentPolicy.package_policies && agentPolicy.package_policies.length || 0
    })
  }, {
    isDivider: true
  }, {
    label: _i18n.i18n.translate('xpack.fleet.policyDetails.summary.usedBy', {
      defaultMessage: 'Agents'
    }),
    content: agentStatus && agentStatus.total ? /*#__PURE__*/_react.default.createElement(_components.LinkedAgentCount, {
      count: agentStatus.total,
      agentPolicyId: agentPolicy && agentPolicy.id || '',
      showAgentText: true
    }) : agentPolicy !== null && agentPolicy !== void 0 && agentPolicy.is_managed ? /*#__PURE__*/_react.default.createElement(_components.LinkedAgentCount, {
      count: 0,
      agentPolicyId: agentPolicy && agentPolicy.id || '',
      showAgentText: true
    }) : /*#__PURE__*/_react.default.createElement(_components2.AddAgentHelpPopover, {
      button: addAgentLink,
      isOpen: isAddAgentHelpPopoverOpen,
      offset: 15,
      closePopover: () => {
        setIsAddAgentHelpPopoverOpen(false);
      }
    })
  }, {
    isDivider: true
  }, {
    label: _i18n.i18n.translate('xpack.fleet.policyDetails.summary.lastUpdated', {
      defaultMessage: 'Last updated on'
    }),
    content: agentPolicy && /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedDate, {
      value: agentPolicy === null || agentPolicy === void 0 ? void 0 : agentPolicy.updated_at,
      year: "numeric",
      month: "short",
      day: "2-digit"
    }) || ''
  }, {
    isDivider: true
  }, {
    content: agentPolicy && /*#__PURE__*/_react.default.createElement(_components.AgentPolicyActionMenu, {
      agentPolicy: agentPolicy,
      fullButton: true,
      onCopySuccess: newAgentPolicy => {
        history.push(getPath('policy_details', {
          policyId: newAgentPolicy.id
        }));
      },
      onCancelEnrollment: onCancelEnrollment
    })
  }].map((item, index) => {
    var _item$isDivider;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: index
    }, ((_item$isDivider = item.isDivider) !== null && _item$isDivider !== void 0 ? _item$isDivider : false) ? /*#__PURE__*/_react.default.createElement(Divider, null) : item.label ? /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      compressed: true,
      textStyle: "reverse",
      style: {
        textAlign: 'right'
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      className: "eui-textNoWrap"
    }, item.label), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      className: "eui-textNoWrap"
    }, item.content)) : item.content);
  }));
};
exports.HeaderRightContent = HeaderRightContent;