"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MultiTextInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Row = ({
  index,
  value,
  onChange,
  onDelete,
  onBlur,
  autoFocus,
  isDisabled,
  showDeleteButton
}) => {
  const onDeleteHandler = (0, _react.useCallback)(() => {
    onDelete(index);
  }, [onDelete, index]);
  const onChangeHandler = (0, _react.useCallback)(e => {
    onChange(index, e.target.value);
  }, [onChange, index]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "none",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    fullWidth: true,
    value: value,
    onChange: onChangeHandler,
    autoFocus: autoFocus,
    disabled: isDisabled,
    onBlur: onBlur,
    "data-test-subj": `multiTextInputRow-${index}`
  })), showDeleteButton && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    onClick: onDeleteHandler,
    iconType: "cross",
    disabled: isDisabled,
    "aria-label": _i18n.i18n.translate('xpack.fleet.multiTextInput.deleteRowButton', {
      defaultMessage: 'Delete row'
    })
  })));
};
function defaultValue(value) {
  return value.length > 0 ? value : [''];
}
const MultiTextInput = ({
  value,
  onChange,
  onBlur,
  isInvalid,
  isDisabled,
  errors,
  'data-test-subj': dataTestSubj
}) => {
  const [autoFocus, setAutoFocus] = (0, _react.useState)(false);
  const [rows, setRows] = (0, _react.useState)(() => defaultValue(value));
  const [previousRows, setPreviousRows] = (0, _react.useState)(rows);
  (0, _react.useEffect)(() => {
    if (previousRows === rows) {
      return;
    }
    setPreviousRows(rows);
    if (rows[rows.length - 1] === '') {
      onChange(rows.slice(0, rows.length - 1));
    } else {
      onChange(rows);
    }
  }, [onChange, previousRows, rows]);
  const onDeleteHandler = (0, _react.useCallback)(idx => {
    setRows([...rows.slice(0, idx), ...rows.slice(idx + 1)]);
  }, [rows]);
  const onChangeHandler = (0, _react.useCallback)((idx, newValue) => {
    const newRows = [...rows];
    newRows[idx] = newValue;
    setRows(newRows);
  }, [rows]);
  const addRowHandler = (0, _react.useCallback)(() => {
    setAutoFocus(true);
    setRows([...rows, '']);
  }, [rows]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    "data-test-subj": dataTestSubj
  }, rows.map((row, idx) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: idx
  }, /*#__PURE__*/_react.default.createElement(Row, {
    index: idx,
    onChange: onChangeHandler,
    onDelete: onDeleteHandler,
    onBlur: onBlur,
    value: row,
    autoFocus: autoFocus,
    isDisabled: isDisabled,
    showDeleteButton: rows.length > 1
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    disabled: isDisabled,
    size: "xs",
    flush: "left",
    iconType: "plusInCircle",
    onClick: addRowHandler
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.multiTextInput.addRow",
    defaultMessage: "Add row"
  })));
};
exports.MultiTextInput = MultiTextInput;