"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PackagePolicyEditorDatastreamMappings = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _services = require("../../../../../../../common/services");
var _hooks = require("../../../../hooks");
var _datastream_hooks = require("./datastream_hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useComponentTemplates(dataStream) {
  return [{
    templateName: (0, _services.getComponentTemplateNameForDatastream)(dataStream, '@package')
  }, {
    templateName: (0, _services.getComponentTemplateNameForDatastream)(dataStream, '@custom'),
    canEdit: true
  }];
}
const PackagePolicyEditorDatastreamMappings = ({
  packageInputStream,
  packageInfo,
  customDataset
}) => {
  const dataStream = customDataset ? {
    ...packageInputStream.data_stream,
    dataset: customDataset
  } : packageInputStream.data_stream;
  const pageUrl = (0, _datastream_hooks.usePackagePolicyEditorPageUrl)(packageInputStream.id);
  const {
    application,
    docLinks
  } = (0, _hooks.useStartServices)();
  const componentTemplateItems = useComponentTemplates(dataStream);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs",
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.packagePolicyEditor.datastreamMappings.title",
    defaultMessage: "Mappings"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.packagePolicyEditor.datastreamMappings.description",
    defaultMessage: "Mapping is the process of defining how a document, and the fields it contains, are stored and indexed. If you are adding new fields through custom ingest pipeline, we recommend addition of a mapping for those in the component template. {learnMoreLink}",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: docLinks.links.fleet.datastreams,
        external: true
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.fleet.packagePolicyEditor.datastreamMappings.learnMoreLink",
        defaultMessage: "Learn more"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: componentTemplateItems,
    columns: [{
      field: 'templateName',
      name: ''
    }, {
      width: '60px',
      actions: [{
        icon: 'pencil',
        type: 'icon',
        description: _i18n.i18n.translate('xpack.fleet.packagePolicyEditor.datastreamMappings.editBtn', {
          defaultMessage: 'Edit mappings'
        }),
        'data-test-subj': 'datastreamEditMappingsBtn',
        name: 'edit',
        isPrimary: true,
        onClick: async el => {
          const url = application.getUrlForApp('management', {
            path: `/data/index_management/edit_component_template/${el.templateName}`
          });
          application.navigateToUrl(`${url}?step=mappings&redirect_path=${pageUrl}`);
        },
        available: ({
          canEdit
        }) => !!canEdit
      }, {
        icon: 'inspect',
        type: 'icon',
        description: _i18n.i18n.translate('xpack.fleet.packagePolicyEditor.datastreamMappings.inspectBtn', {
          defaultMessage: 'Inspect mappings'
        }),
        name: 'inspect',
        'data-test-subj': 'datastreamInspectMappingsBtn',
        isPrimary: true,
        onClick: async el => {
          const url = application.getUrlForApp('management', {
            path: `/data/index_management/component_templates/${el.templateName}`
          });
          application.navigateToUrl(`${url}?redirect_path=${pageUrl}`);
        }
      }]
    }]
  })));
};
exports.PackagePolicyEditorDatastreamMappings = PackagePolicyEditorDatastreamMappings;