"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FleetServerHostSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = require("styled-components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FleetServerHostSelect = ({
  selectedFleetServerHost,
  setFleetServerHost,
  fleetServerHosts
}) => {
  const theme = (0, _styledComponents.useTheme)();
  const fleetServerHostsOptions = (0, _react.useMemo)(() => [...fleetServerHosts.map(fleetServerHost => {
    return {
      inputDisplay: `${fleetServerHost.name} (${fleetServerHost.host_urls[0]})`,
      value: fleetServerHost.id
    };
  }), {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "plus",
      size: "m",
      color: "primary"
    }),
    inputDisplay: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.addFleetServerHostBtn",
      defaultMessage: "Add new Fleet Server Hosts"
    }),
    dropdownDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "relative",
      color: theme.eui.euiColorPrimary
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.addFleetServerHostBtn",
      defaultMessage: "Add new Fleet Server Hosts"
    })),
    'data-test-subj': 'fleetServerSetup.addNewHostBtn',
    value: '@@##ADD_FLEET_SERVER_HOST##@@'
  }], [fleetServerHosts, theme.eui.euiColorPrimary]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    fullWidth: true,
    "data-test-subj": "fleetServerSetup.fleetServerHostsSelect",
    prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "relative",
      color: ''
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.fleetServerSetup.fleetServerHostsLabel",
      defaultMessage: "Fleet Server Hosts"
    })),
    onChange: fleetServerHostId => setFleetServerHost(fleetServerHosts.find(fleetServerHost => fleetServerHost.id === fleetServerHostId)),
    valueOfSelected: selectedFleetServerHost === null || selectedFleetServerHost === void 0 ? void 0 : selectedFleetServerHost.id,
    options: fleetServerHostsOptions
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }));
};
exports.FleetServerHostSelect = FleetServerHostSelect;