"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.differsOnlyInPatch = exports.AGENT_UPGRADE_COOLDOWN_IN_MIN = void 0;
exports.getRecentUpgradeInfoForAgent = getRecentUpgradeInfoForAgent;
exports.isAgentUpgradeable = isAgentUpgradeable;
exports.isAgentUpgrading = isAgentUpgrading;
var _coerce = _interopRequireDefault(require("semver/functions/coerce"));
var _lt = _interopRequireDefault(require("semver/functions/lt"));
var _gt = _interopRequireDefault(require("semver/functions/gt"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENT_UPGRADE_COOLDOWN_IN_MIN = 10;
exports.AGENT_UPGRADE_COOLDOWN_IN_MIN = AGENT_UPGRADE_COOLDOWN_IN_MIN;
function isAgentUpgradeable(agent, latestAgentVersion, versionToUpgrade) {
  var _agent$local_metadata, _agent$local_metadata2, _agent$local_metadata3;
  let agentVersion;
  if (typeof (agent === null || agent === void 0 ? void 0 : (_agent$local_metadata = agent.local_metadata) === null || _agent$local_metadata === void 0 ? void 0 : (_agent$local_metadata2 = _agent$local_metadata.elastic) === null || _agent$local_metadata2 === void 0 ? void 0 : (_agent$local_metadata3 = _agent$local_metadata2.agent) === null || _agent$local_metadata3 === void 0 ? void 0 : _agent$local_metadata3.version) === 'string') {
    agentVersion = agent.local_metadata.elastic.agent.version;
  } else {
    return false;
  }
  if (agent.unenrollment_started_at || agent.unenrolled_at) {
    return false;
  }
  if (!agent.local_metadata.elastic.agent.upgradeable) {
    return false;
  }
  if (isAgentUpgrading(agent)) {
    return false;
  }
  if (getRecentUpgradeInfoForAgent(agent).hasBeenUpgradedRecently) {
    return false;
  }
  if (versionToUpgrade !== undefined) {
    return isNotDowngrade(agentVersion, versionToUpgrade);
  }
  return isAgentVersionLessThanLatest(agentVersion, latestAgentVersion);
}
const isAgentVersionLessThanLatest = (agentVersion, latestAgentVersion) => {
  // make sure versions are only the number before comparison
  const agentVersionNumber = (0, _coerce.default)(agentVersion);
  if (!agentVersionNumber) throw new Error('agent version is not valid');
  const latestAgentVersionNumber = (0, _coerce.default)(latestAgentVersion);
  if (!latestAgentVersionNumber) throw new Error('latest version is not valid');
  return (0, _lt.default)(agentVersionNumber, latestAgentVersionNumber);
};
const isNotDowngrade = (agentVersion, versionToUpgrade) => {
  const agentVersionNumber = (0, _coerce.default)(agentVersion);
  if (!agentVersionNumber) throw new Error('agent version is not valid');
  const versionToUpgradeNumber = (0, _coerce.default)(versionToUpgrade);
  if (!versionToUpgradeNumber) throw new Error('target version is not valid');
  return (0, _gt.default)(versionToUpgradeNumber, agentVersionNumber);
};
function getRecentUpgradeInfoForAgent(agent) {
  if (!agent.upgraded_at) {
    return {
      hasBeenUpgradedRecently: false,
      timeToWaitMs: 0
    };
  }
  const elaspedSinceUpgradeInMillis = Date.now() - Date.parse(agent.upgraded_at);
  const timeToWaitMs = AGENT_UPGRADE_COOLDOWN_IN_MIN * 6e4 - elaspedSinceUpgradeInMillis;
  const hasBeenUpgradedRecently = elaspedSinceUpgradeInMillis / 6e4 < AGENT_UPGRADE_COOLDOWN_IN_MIN;
  return {
    hasBeenUpgradedRecently,
    timeToWaitMs
  };
}
function isAgentUpgrading(agent) {
  if (agent.upgrade_details) {
    return agent.upgrade_details.state !== 'UPG_FAILED';
  }
  return agent.upgrade_started_at && !agent.upgraded_at;
}
const differsOnlyInPatch = (versionA, versionB, allowEqualPatch = true) => {
  const [majorA, minorA, patchA] = versionA.split('.');
  const [majorB, minorB, patchB] = versionB.split('.');
  return majorA === majorB && minorA === minorB && (allowEqualPatch ? patchA >= patchB : patchA > patchB);
};
exports.differsOnlyInPatch = differsOnlyInPatch;