"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilesPluginError = void 0;
exports.createDefaultFileAttributes = createDefaultFileAttributes;
exports.wrapErrorAndReThrow = void 0;
var _elasticsearch = require("@elastic/elasticsearch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function createDefaultFileAttributes() {
  const dateString = new Date().toISOString();
  return {
    created: dateString,
    Status: 'AWAITING_UPLOAD',
    Updated: dateString
  };
}
class FilesPluginError extends Error {
  constructor(message, meta) {
    super(message);
    // For debugging - capture name of subclasses
    this.meta = meta;
    this.name = this.constructor.name;
  }
}
exports.FilesPluginError = FilesPluginError;
/**
 * A helper method that can be used with Promises to wrap errors encountered with more details
 * info. Mainly useful with calls to SO/ES as those errors normally don't include a good stack
 * trace that points to where the error occurred.
 * @param e
 * @param messagePrefix
 */
const wrapErrorAndReThrow = (e, messagePrefix = '') => {
  if (e instanceof FilesPluginError) {
    throw e;
  }
  let details = '';

  // Create additional details based on known errors
  if (e instanceof _elasticsearch.errors.ResponseError) {
    details = `\nRequest: ${e.meta.meta.request.params.method} ${e.meta.meta.request.params.path}`;
  }
  throw new FilesPluginError(messagePrefix + e.message + details, e);
};
exports.wrapErrorAndReThrow = wrapErrorAndReThrow;
wrapErrorAndReThrow.withMessagePrefix = messagePrefix => {
  return e => {
    return wrapErrorAndReThrow(e, messagePrefix);
  };
};