"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexNameForm = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _validate_index_name = require("../../validate_index_name");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class IndexNameForm extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_onIndexNameChange", event => {
      const indexName = event.target.value;
      this.props.onIndexNameChange(indexName);
      this._validateIndexName(indexName);
      this.props.onIndexNameValidationStart();
    });
    (0, _defineProperty2.default)(this, "_validateIndexName", _lodash.default.debounce(async indexName => {
      const indexNameError = await (0, _validate_index_name.validateIndexName)(indexName);
      if (!this._isMounted || indexName !== this.props.indexName) {
        return;
      }
      this.props.onIndexNameValidationEnd();
      this.props.onIndexNameChange(indexName, indexNameError);
    }, 500));
  }
  componentDidMount() {
    this._isMounted = true;
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  render() {
    const errors = [...(this.props.indexNameError ? [this.props.indexNameError] : [])];
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.fileUpload.indexNameForm.enterIndexNameLabel', {
        defaultMessage: 'Index name'
      }),
      isInvalid: !!errors.length,
      error: errors
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      "data-test-subj": "fileUploadIndexNameInput",
      value: this.props.indexName,
      onChange: this._onIndexNameChange,
      isInvalid: !!errors.length,
      "aria-label": _i18n.i18n.translate('xpack.fileUpload.indexNameForm.indexNameReqField', {
        defaultMessage: 'Index name, required field'
      })
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.fileUpload.indexNameForm.indexNameGuidelines', {
        defaultMessage: 'Index name guidelines'
      }),
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("ul", {
      style: {
        marginBottom: 0
      }
    }, /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.fileUpload.indexNameForm.guidelines.mustBeNewIndex', {
      defaultMessage: 'Must be a new index'
    })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.fileUpload.indexNameForm.guidelines.lowercaseOnly', {
      defaultMessage: 'Lowercase only'
    })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.fileUpload.indexNameForm.guidelines.cannotInclude', {
      defaultMessage: 'Cannot include \\\\, /, *, ?, ", <, >, |, \
                  " " (space character), , (comma), #'
    })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.fileUpload.indexNameForm.guidelines.cannotStartWith', {
      defaultMessage: 'Cannot start with -, _, +'
    })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.fileUpload.indexNameForm.guidelines.cannotBe', {
      defaultMessage: 'Cannot be . or ..'
    })), /*#__PURE__*/_react.default.createElement("li", null, _i18n.i18n.translate('xpack.fileUpload.indexNameForm.guidelines.length', {
      defaultMessage: 'Cannot be longer than 255 bytes (note it is bytes, \
                  so multi-byte characters will count towards the 255 \
                  limit faster)'
    })))));
  }
}
exports.IndexNameForm = IndexNameForm;