"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useShallowMemo = useShallowMemo;
var _react = require("react");
var _shallowEqual = _interopRequireDefault(require("react-redux/lib/utils/shallowEqual"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// eslint-disable-next-line @typescript-eslint/triple-slash-reference, spaced-comment
/// <reference path="./shallow_equal.d.ts" />

function useShallowMemo(value) {
  const previousRef = (0, _react.useRef)(value);
  if (!(0, _shallowEqual.default)(previousRef.current, value)) {
    previousRef.current = value;
  }
  return previousRef.current;
}