"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReactExpressionRenderer = ReactExpressionRenderer;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _classnames = _interopRequireDefault(require("classnames"));
var _panelLoader = require("@kbn/panel-loader");
var _eui = require("@elastic/eui");
var _use_expression_renderer = require("./use_expression_renderer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

// Accept all options of the runner as props except for the
// dom element which is provided by the component itself

function ReactExpressionRenderer({
  className,
  dataAttrs,
  padding,
  renderError,
  ...expressionRendererOptions
}) {
  const nodeRef = (0, _react.useRef)(null);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    error,
    isEmpty,
    isLoading
  } = (0, _use_expression_renderer.useExpressionRenderer)(nodeRef, {
    ...expressionRendererOptions,
    hasCustomErrorRenderer: !!renderError
  });
  const classes = (0, _classnames.default)('expExpressionRenderer', className, {
    'expExpressionRenderer-isEmpty': isEmpty,
    'expExpressionRenderer-hasError': !!error
  });
  const expressionStyles = {};
  if (padding) {
    expressionStyles.padding = euiTheme.size[padding];
  }
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, dataAttrs, {
    className: classes
  }), isEmpty && /*#__PURE__*/_react.default.createElement(_panelLoader.PanelLoader, null), isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "accent",
    position: "absolute",
    style: {
      zIndex: 1
    }
  }), !isLoading && error && (renderError === null || renderError === void 0 ? void 0 : renderError(error.message, error)), /*#__PURE__*/_react.default.createElement("div", {
    className: "expExpressionRenderer__expression",
    style: expressionStyles,
    ref: nodeRef
  }));
}