"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getShape = void 0;
var _gauge = require("./gauge");
var _horizontal_bar = require("./horizontal_bar");
var _horizontal_pill = require("./horizontal_pill");
var _semicircle = require("./semicircle");
var _unicorn = require("./unicorn");
var _vertical_bar = require("./vertical_bar");
var _vertical_pill = require("./vertical_pill");
var _wheel = require("./wheel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const shapes = {
  gauge: _gauge.Gauge,
  horizontalBar: _horizontal_bar.HorizontalBar,
  horizontalPill: _horizontal_pill.HorizontalPill,
  semicircle: _semicircle.Semicircle,
  unicorn: _unicorn.Unicorn,
  verticalBar: _vertical_bar.VerticalBar,
  verticalPill: _vertical_pill.VerticalPill,
  wheel: _wheel.Wheel
};
const getShape = shapeType => shapes[shapeType];
exports.getShape = getShape;