"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.strings = exports.getPartitionVisRenderer = exports.getColumnCellValueActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactDom = require("react-dom");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/presentation-util-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _analytics = require("@kbn/analytics");
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _chartExpressionsCommon = require("@kbn/chart-expressions-common");
var _constants = require("../../common/constants");
var _types = require("../../common/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0 and the Server Side Public License, v 1; you may not use this file except
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * in compliance with, at your election, the Elastic License 2.0 or the Server
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Side Public License, v 1.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const strings = {
  getDisplayName: () => _i18n.i18n.translate('expressionPartitionVis.renderer.partitionVis.pie.displayName', {
    defaultMessage: 'Partition visualization'
  }),
  getHelpDescription: () => _i18n.i18n.translate('expressionPartitionVis.renderer.partitionVis.pie.helpDescription', {
    defaultMessage: 'Render pie/donut/treemap/mosaic/waffle charts'
  })
};
exports.strings = strings;
const LazyPartitionVisComponent = /*#__PURE__*/(0, _react.lazy)(() => Promise.resolve().then(() => _interopRequireWildcard(require('../components/partition_vis_component'))));
const PartitionVisComponent = (0, _public.withSuspense)(LazyPartitionVisComponent);
const partitionVisRenderer = (0, _react2.css)({
  position: 'relative',
  width: '100%',
  height: '100%'
});

/**
 * Retrieves the compatible CELL_VALUE_TRIGGER actions indexed by column
 **/
const getColumnCellValueActions = async (visConfig, visData, getCompatibleCellValueActions) => {
  if (!Array.isArray(visConfig.dimensions.buckets) || !getCompatibleCellValueActions) {
    return [];
  }
  return Promise.all(visConfig.dimensions.buckets.reduce((acc, accessor) => {
    var _getColumnByAccessor;
    const columnMeta = (_getColumnByAccessor = (0, _utils.getColumnByAccessor)(accessor, visData.columns)) === null || _getColumnByAccessor === void 0 ? void 0 : _getColumnByAccessor.meta;
    if (columnMeta) {
      acc.push(getCompatibleCellValueActions([{
        columnMeta
      }]));
    }
    return acc;
  }, []));
};
exports.getColumnCellValueActions = getColumnCellValueActions;
const getPartitionVisRenderer = ({
  getStartDeps
}) => ({
  name: _constants.PARTITION_VIS_RENDERER_NAME,
  displayName: strings.getDisplayName(),
  help: strings.getHelpDescription(),
  reuseDomNode: true,
  render: async (domNode, {
    visConfig,
    visData,
    visType,
    syncColors,
    canNavigateToLens,
    overrides
  }, handlers) => {
    const {
      core,
      plugins
    } = getStartDeps();
    handlers.onDestroy(() => {
      (0, _reactDom.unmountComponentAtNode)(domNode);
    });
    const renderComplete = () => {
      const executionContext = handlers.getExecutionContext();
      const containerType = (0, _chartExpressionsCommon.extractContainerType)(executionContext);
      const visualizationType = (0, _chartExpressionsCommon.extractVisualizationType)(executionContext);
      if (containerType && visualizationType) {
        var _plugins$usageCollect;
        const events = [`render_${visualizationType}_${visType}`, canNavigateToLens ? `render_${visualizationType}_${visType}_convertable` : undefined].filter(event => Boolean(event));
        (_plugins$usageCollect = plugins.usageCollection) === null || _plugins$usageCollect === void 0 ? void 0 : _plugins$usageCollect.reportUiCounter(containerType, _analytics.METRIC_TYPE.COUNT, events);
      }
      handlers.done();
    };
    const [columnCellValueActions, palettesRegistry] = await Promise.all([getColumnCellValueActions(visConfig, visData, handlers.getCompatibleCellValueActions), plugins.charts.palettes.getPalettes()]);
    const hasOpenedOnAggBasedEditor = (0, _chartExpressionsCommon.isOnAggBasedEditor)(handlers.getExecutionContext());
    (0, _reactDom.render)( /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaThemeProvider, {
      theme$: core.theme.theme$
    }, /*#__PURE__*/_react.default.createElement("div", {
      css: partitionVisRenderer
    }, /*#__PURE__*/_react.default.createElement(PartitionVisComponent, {
      chartsThemeService: plugins.charts.theme,
      palettesRegistry: palettesRegistry,
      visParams: visConfig,
      visData: visData,
      visType: visConfig.isDonut ? _types.ChartTypes.DONUT : visType,
      renderComplete: renderComplete,
      fireEvent: handlers.event,
      interactive: handlers.isInteractive(),
      uiState: handlers.uiState,
      services: {
        data: plugins.data,
        fieldFormats: plugins.fieldFormats
      },
      syncColors: syncColors,
      columnCellValueActions: columnCellValueActions,
      overrides: overrides,
      hasOpenedOnAggBasedEditor: hasOpenedOnAggBasedEditor
    })))), domNode);
  }
});
exports.getPartitionVisRenderer = getPartitionVisRenderer;