"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReportMetricOptions = ReportMetricOptions;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_series_storage = require("../hooks/use_series_storage");
var _use_app_data_view = require("../hooks/use_app_data_view");
var _constants = require("../configurations/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ReportMetricOptions({
  seriesId,
  series,
  seriesConfig
}) {
  var _seriesConfig$metricO, _seriesConfig$metricO2, _seriesConfig$metricO3;
  const {
    setSeries
  } = (0, _use_series_storage.useSeriesStorage)();
  const [showOptions, setShowOptions] = (0, _react.useState)(false);
  const metricOptions = seriesConfig === null || seriesConfig === void 0 ? void 0 : seriesConfig.metricOptions;
  const {
    dataViews,
    dataViewErrors,
    loading
  } = (0, _use_app_data_view.useAppDataViewContext)();
  const onChange = value => {
    setSeries(seriesId, {
      ...series,
      selectedMetricField: value
    });
  };
  const focusButton = (0, _react.useCallback)(ref => {
    ref === null || ref === void 0 ? void 0 : ref.focus();
  }, []);
  if (!series.dataType) {
    return null;
  }
  const dataView = dataViews === null || dataViews === void 0 ? void 0 : dataViews[series.dataType];
  const dataViewError = dataViewErrors === null || dataViewErrors === void 0 ? void 0 : dataViewErrors[series.dataType];
  const options = (metricOptions !== null && metricOptions !== void 0 ? metricOptions : []).map(({
    label,
    field,
    id
  }) => {
    let disabled = false;
    if (field !== _constants.RECORDS_FIELD && field !== _constants.RECORDS_PERCENTAGE_FIELD && field) {
      disabled = !Boolean(dataView === null || dataView === void 0 ? void 0 : dataView.getFieldByName(field));
    }
    return {
      disabled,
      value: field || id,
      dropdownDisplay: disabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.exploratoryView.expView.seriesEditor.selectReportMetric.noFieldData",
          defaultMessage: "No data available for field {field}.",
          values: {
            field: /*#__PURE__*/_react.default.createElement("strong", null, field)
          }
        })
      }, /*#__PURE__*/_react.default.createElement("span", null, label)) : label,
      inputDisplay: label
    };
  });
  if (dataViewError && !dataView && !loading) {
    var _dataViewError$body, _dataViewError$body2;
    // TODO: Add a link to docs to explain how to add index patterns
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "danger",
      className: "eui-textNoWrap"
    }, ((_dataViewError$body = dataViewError.body) === null || _dataViewError$body === void 0 ? void 0 : _dataViewError$body.error) === 'Forbidden' || dataViewError.name === 'DataViewInsufficientAccessError' ? NO_PERMISSIONS : (_dataViewError$body2 = dataViewError.body) === null || _dataViewError$body2 === void 0 ? void 0 : _dataViewError$body2.message);
  }
  if (!dataView && !loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, NO_DATA_AVAILABLE);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !series.selectedMetricField && /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "o11yReportMetricOptionsButton",
      iconType: "plusInCircle",
      onClick: () => setShowOptions(prevState => !prevState),
      fill: true,
      size: "s",
      isLoading: !dataView && loading,
      buttonRef: focusButton
    }, SELECT_REPORT_METRIC_LABEL),
    isOpen: showOptions,
    closePopover: () => setShowOptions(prevState => !prevState)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, null, options.map(option => /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    key: option.value,
    onClick: () => onChange(option.value),
    label: option.dropdownDisplay,
    isDisabled: option.disabled
  })))), series.selectedMetricField && (dataView ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "top",
    content: REPORT_METRIC_TOOLTIP
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    iconType: "cross",
    iconSide: "right",
    iconOnClick: () => onChange(undefined),
    iconOnClickAriaLabel: REMOVE_REPORT_METRIC_LABEL
  }, (_seriesConfig$metricO = seriesConfig === null || seriesConfig === void 0 ? void 0 : (_seriesConfig$metricO2 = seriesConfig.metricOptions) === null || _seriesConfig$metricO2 === void 0 ? void 0 : (_seriesConfig$metricO3 = _seriesConfig$metricO2.find(option => option.id === series.selectedMetricField || option.field === series.selectedMetricField)) === null || _seriesConfig$metricO3 === void 0 ? void 0 : _seriesConfig$metricO3.label) !== null && _seriesConfig$metricO !== void 0 ? _seriesConfig$metricO : series.selectedMetricField)) : /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null)));
}
const SELECT_REPORT_METRIC_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.selectReportMetric', {
  defaultMessage: 'Select report metric'
});
const REMOVE_REPORT_METRIC_LABEL = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.removeReportMetric', {
  defaultMessage: 'Remove report metric'
});
const NO_DATA_AVAILABLE = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.noData', {
  defaultMessage: 'No data available'
});
const NO_PERMISSIONS = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.noPermissions', {
  defaultMessage: "Unable to create Data View. You don't have the required permission, please contact your admin."
});
const REPORT_METRIC_TOOLTIP = _i18n.i18n.translate('xpack.exploratoryView.expView.seriesEditor.reportMetricTooltip', {
  defaultMessage: 'Report metric'
});