"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isGroupValid = exports.GroupEditorControls = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _uiTheme = require("@kbn/ui-theme");
var _react2 = _interopRequireWildcard(require("react"));
var _eventAnnotationComponents = require("@kbn/event-annotation-components");
var _annotation_list = require("./annotation_list");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const isTitleValid = title => Boolean(title.length);
const isDataViewValid = dataView => Boolean(dataView === null || dataView === void 0 ? void 0 : dataView.id);
const isGroupValid = (group, dataViews) => isTitleValid(group.title) && isDataViewValid(dataViews.find(({
  id
}) => id === group.indexPatternId));
exports.isGroupValid = isGroupValid;
const GroupEditorControls = ({
  group,
  update,
  setSelectedAnnotation: _setSelectedAnnotation,
  selectedAnnotation,
  TagSelector,
  dataViews,
  queryInputServices,
  showValidation,
  isAdHocDataView
}) => {
  const setSelectedAnnotation = (0, _react2.useCallback)(newSelection => {
    update({
      ...group,
      annotations: group.annotations.map(annotation => annotation.id === newSelection.id ? newSelection : annotation)
    });
    _setSelectedAnnotation(newSelection);
  }, [_setSelectedAnnotation, group, update]);
  const currentDataView = (0, _react2.useMemo)(() => dataViews.find(dataView => dataView.id === group.indexPatternId), [dataViews, group.indexPatternId]);
  return !selectedAnnotation ? /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    css: (0, _react.css)`
          margin-bottom: ${_uiTheme.euiThemeVars.euiSize};
        `
  }, /*#__PURE__*/_react2.default.createElement("h3", null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "eventAnnotationListing.groupEditor.details",
    defaultMessage: "Details"
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('eventAnnotationListing.groupEditor.title', {
      defaultMessage: 'Title'
    }),
    isInvalid: showValidation && !isTitleValid(group.title),
    error: _i18n.i18n.translate('eventAnnotationListing.groupEditor.titleRequired', {
      defaultMessage: 'A title is required.'
    })
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldText, {
    compressed: true,
    "data-test-subj": "annotationGroupTitle",
    value: group.title,
    isInvalid: showValidation && !isTitleValid(group.title),
    onChange: ({
      target: {
        value
      }
    }) => update({
      ...group,
      title: value
    })
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('eventAnnotationListing.groupEditor.description', {
      defaultMessage: 'Description'
    }),
    labelAppend: /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs"
    }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "eventAnnotationListing.groupEditor.optional",
      defaultMessage: "Optional"
    }))
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTextArea, {
    compressed: true,
    "data-test-subj": "annotationGroupDescription",
    value: group.description,
    onChange: ({
      target: {
        value
      }
    }) => update({
      ...group,
      description: value
    })
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react2.default.createElement(TagSelector, {
    initialSelection: group.tags,
    markOptional: true,
    compressed: true,
    onTagsSelected: tags => update({
      ...group,
      tags
    })
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('eventAnnotationListing.groupEditor.dataView', {
      defaultMessage: 'Data view'
    }),
    isInvalid: !isDataViewValid(currentDataView),
    error: !isDataViewValid(currentDataView) ? _i18n.i18n.translate('eventAnnotationListing.groupEditor.dataViewMissingError', {
      defaultMessage: 'The previously selected data view no longer exists.'
    }) : ''
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSelect, {
    compressed: true,
    "data-test-subj": "annotationDataViewSelection",
    isInvalid: !isDataViewValid(currentDataView),
    options: dataViews.map(({
      id: value,
      title,
      name
    }) => ({
      value,
      text: name !== null && name !== void 0 ? name : title
    })),
    value: isDataViewValid(currentDataView) ? group.indexPatternId : undefined,
    hasNoInitialSelection: true,
    onChange: ({
      target: {
        value
      }
    }) => {
      const selectedDataView = dataViews.find(({
        id
      }) => id === value);
      if (!(selectedDataView !== null && selectedDataView !== void 0 && selectedDataView.id)) {
        return;
      }
      update({
        ...group,
        indexPatternId: value,
        dataViewSpec: isAdHocDataView(selectedDataView.id) ? selectedDataView.toSpec(false) : undefined
      });
    }
  }))), /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
          margin-top: ${_uiTheme.euiThemeVars.euiSize};
          padding-top: ${_uiTheme.euiThemeVars.euiSize};
          position: relative;

          &:before {
            content: '';
            position: absolute;
            top: 0;
            right: -${_uiTheme.euiThemeVars.euiSize};
            left: -${_uiTheme.euiThemeVars.euiSize};
            border-top: 1px solid ${_uiTheme.euiThemeVars.euiColorLightShade};
          }
        `
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    css: (0, _react.css)`
            margin-bottom: ${_uiTheme.euiThemeVars.euiSize};
          `
  }, /*#__PURE__*/_react2.default.createElement("h3", null, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "eventAnnotationListing.groupEditor.annotations",
    defaultMessage: "Annotations"
  }))), /*#__PURE__*/_react2.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('eventAnnotationListing.groupEditor.annotationGroupLabel', {
      defaultMessage: 'Date histogram axis'
    })
  }, /*#__PURE__*/_react2.default.createElement(_annotation_list.AnnotationList, {
    annotations: group.annotations,
    selectAnnotation: currentDataView ? setSelectedAnnotation : () => {},
    update: newAnnotations => update({
      ...group,
      annotations: newAnnotations
    })
  }))))) : currentDataView ? /*#__PURE__*/_react2.default.createElement(_eventAnnotationComponents.AnnotationEditorControls, {
    annotation: selectedAnnotation,
    onAnnotationChange: changes => setSelectedAnnotation({
      ...selectedAnnotation,
      ...changes
    }),
    dataView: currentDataView,
    getDefaultRangeEnd: rangeStart => rangeStart,
    queryInputServices: queryInputServices,
    appName: _eventAnnotationComponents.EVENT_ANNOTATION_APP_NAME
  }) : null;
};
exports.GroupEditorControls = GroupEditorControls;