"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormWizardStep = void 0;
var _react = require("react");
var _form_wizard_context = require("./form_wizard_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const FormWizardStep = ({
  id,
  label,
  isRequired,
  children
}) => {
  const {
    activeStepId,
    addStep
  } = (0, _form_wizard_context.useFormWizardContext)();
  (0, _react.useEffect)(() => {
    addStep(id, label, isRequired);
  }, [id, label, isRequired, addStep]);
  return activeStepId === id ? children : null;
};
exports.FormWizardStep = FormWizardStep;