"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _public = require("@kbn/kibana-react-plugin/public");
var _use_json = require("./use_json");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function JsonEditorComp({
  label,
  helpText,
  onUpdate,
  value,
  defaultValue,
  codeEditorProps,
  error: propsError,
  ...rest
}) {
  const {
    content,
    setContent,
    error: internalError,
    isControlled
  } = (0, _use_json.useJson)({
    defaultValue,
    onUpdate,
    value
  });
  const debouncedSetContent = (0, _react.useMemo)(() => {
    return (0, _lodash.debounce)(setContent, 300);
  }, [setContent]);

  // We let the consumer control the validation and the error message.
  const error = isControlled ? propsError : internalError;
  const onEuiCodeEditorChange = (0, _react.useCallback)(updated => {
    if (isControlled) {
      onUpdate({
        data: {
          raw: updated,
          format: () => JSON.parse(updated)
        },
        validate: () => {
          try {
            JSON.parse(updated);
            return true;
          } catch (e) {
            return false;
          }
        },
        isValid: undefined
      });
    } else {
      debouncedSetContent(updated);
    }
  }, [isControlled, debouncedSetContent, onUpdate]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    label: label,
    helpText: helpText,
    isInvalid: typeof error === 'string',
    error: error,
    fullWidth: true
  }, rest), /*#__PURE__*/_react.default.createElement(_public.CodeEditor, (0, _extends2.default)({
    languageId: "json",
    height: 500,
    options: {
      lineNumbers: 'off',
      tabSize: 2,
      automaticLayout: true
    },
    value: isControlled ? value : content,
    onChange: onEuiCodeEditorChange
  }, codeEditorProps)));
}
const JsonEditor = /*#__PURE__*/_react.default.memo(JsonEditorComp);
exports.JsonEditor = JsonEditor;