"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalConfigService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GlobalConfigService {
  constructor() {
    /**
     *
     */
    (0, _defineProperty2.default)(this, "cloudUrl", void 0);
    /**
     * An observable that emits elasticsearch config.
     */
    (0, _defineProperty2.default)(this, "config$", void 0);
    /**
     * A reference to the subscription to the elasticsearch observable
     */
    (0, _defineProperty2.default)(this, "configSub", void 0);
    /**
     * The elasticsearch config value at a given point in time.
     */
    (0, _defineProperty2.default)(this, "globalConfigElasticsearchUrl", void 0);
  }
  get elasticsearchUrl() {
    return this.cloudUrl ? this.cloudUrl : this.globalConfigElasticsearchUrl || 'https://your_deployment_url';
  }
  setup(config$, cloud) {
    this.cloudUrl = cloud.elasticsearchUrl;
    this.config$ = config$;
    this.configSub = this.config$.subscribe(config => {
      const rawHost = config.hosts[0];
      // strip username, password, URL params and other potentially sensitive info from hosts URL
      const hostUrl = new URL(rawHost);
      this.globalConfigElasticsearchUrl = `${hostUrl.origin}${hostUrl.pathname}`;
    });
  }
  stop() {
    if (this.configSub) {
      this.configSub.unsubscribe();
    }
  }
}
exports.GlobalConfigService = GlobalConfigService;