"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.plugin = exports.configSchema = exports.config = exports.CRAWLERS_INDEX = void 0;
var _configSchema = require("@kbn/config-schema");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const plugin = async initializerContext => {
  const {
    EnterpriseSearchPlugin
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('./plugin')));
  return new EnterpriseSearchPlugin(initializerContext);
};
exports.plugin = plugin;
const configSchema = _configSchema.schema.object({
  accessCheckTimeout: _configSchema.schema.number({
    defaultValue: 5000
  }),
  accessCheckTimeoutWarning: _configSchema.schema.number({
    defaultValue: 300
  }),
  canDeployEntSearch: _configSchema.schema.boolean({
    defaultValue: true
  }),
  customHeaders: _configSchema.schema.maybe(_configSchema.schema.object({}, {
    unknowns: 'allow'
  })),
  enabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasConnectors: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasDefaultIngestPipeline: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasDocumentLevelSecurityEnabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasIncrementalSyncEnabled: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasNativeConnectors: _configSchema.schema.boolean({
    defaultValue: true
  }),
  hasWebCrawler: _configSchema.schema.boolean({
    defaultValue: true
  }),
  host: _configSchema.schema.maybe(_configSchema.schema.string()),
  isCloud: _configSchema.schema.boolean({
    defaultValue: false
  }),
  ssl: _configSchema.schema.object({
    certificateAuthorities: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.arrayOf(_configSchema.schema.string(), {
      minSize: 1
    }), _configSchema.schema.string()])),
    verificationMode: _configSchema.schema.oneOf([_configSchema.schema.literal('none'), _configSchema.schema.literal('certificate'), _configSchema.schema.literal('full')], {
      defaultValue: 'full'
    })
  }),
  ui: _configSchema.schema.object({
    enabled: _configSchema.schema.boolean({
      defaultValue: true
    })
  })
});
exports.configSchema = configSchema;
const config = {
  exposeToBrowser: {
    canDeployEntSearch: true,
    host: true,
    ui: true
  },
  schema: configSchema
};
exports.config = config;
const CRAWLERS_INDEX = '.ent-search-actastic-crawler2_configurations_v2';
exports.CRAWLERS_INDEX = CRAWLERS_INDEX;