"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _routes = require("../../routes");
var _connectors = require("./components/connectors");
var _customize = require("./components/customize");
var _oauth_application = require("./components/oauth_application");
var _source_config = require("./components/source_config");
var _settings_logic = require("./settings_logic");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SettingsRouter = () => {
  const {
    initializeSettings
  } = (0, _kea.useActions)(_settings_logic.SettingsLogic);
  (0, _react.useEffect)(() => {
    initializeSettings();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ORG_SETTINGS_CUSTOMIZE_PATH
  }, /*#__PURE__*/_react.default.createElement(_customize.Customize, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ORG_SETTINGS_CONNECTORS_PATH
  }, /*#__PURE__*/_react.default.createElement(_connectors.Connectors, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ORG_SETTINGS_OAUTH_APPLICATION_PATH
  }, /*#__PURE__*/_react.default.createElement(_oauth_application.OauthApplication, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: (0, _routes.getEditPath)(':serviceType')
  }, /*#__PURE__*/_react.default.createElement(_source_config.SourceConfig, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, null, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: _routes.ORG_SETTINGS_CUSTOMIZE_PATH
  })));
};
exports.SettingsRouter = SettingsRouter;