"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupAssignmentSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _role_mapping = require("../../../shared/role_mapping");
var _constants = require("./constants");
var _role_mappings_logic = require("./role_mappings_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GroupAssignmentSelector = () => {
  const {
    handleAllGroupsSelectionChange,
    handleGroupSelectionChange
  } = (0, _kea.useActions)(_role_mappings_logic.RoleMappingsLogic);
  const {
    includeInAllGroups,
    availableGroups,
    selectedGroups,
    selectedOptions
  } = (0, _kea.useValues)(_role_mappings_logic.RoleMappingsLogic);
  const hasGroupAssignment = selectedGroups.size > 0 || includeInAllGroups;
  const groupOptions = [{
    id: 'all',
    label: /*#__PURE__*/_react.default.createElement(_role_mapping.RoleOptionLabel, {
      label: _constants.ALL_GROUPS_LABEL,
      description: _constants.ALL_GROUPS_DESCRIPTION
    })
  }, {
    id: 'specific',
    label: /*#__PURE__*/_react.default.createElement(_role_mapping.RoleOptionLabel, {
      label: _constants.SPECIFIC_GROUPS_LABEL,
      description: _constants.SPECIFIC_GROUPS_DESCRIPTION
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: groupOptions,
    idSelected: includeInAllGroups ? 'all' : 'specific',
    onChange: id => handleAllGroupsSelectionChange(id === 'all'),
    legend: {
      children: /*#__PURE__*/_react.default.createElement("span", null, _constants.GROUP_ASSIGNMENT_LABEL)
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    isInvalid: !hasGroupAssignment,
    error: [_constants.GROUP_ASSIGNMENT_INVALID_ERROR]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "groupsSelect",
    selectedOptions: selectedOptions,
    options: availableGroups.map(({
      name,
      id
    }) => ({
      label: name,
      value: id
    })),
    onChange: options => {
      handleGroupSelectionChange(options.map(({
        value
      }) => value));
    },
    fullWidth: true,
    isDisabled: includeInAllGroups
  })));
};
exports.GroupAssignmentSelector = GroupAssignmentSelector;