"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSourceSubNav = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _layout = require("../../../../shared/layout");
var _app_logic = require("../../../app_logic");
var _constants = require("../../../constants");
var _routes = require("../../../routes");
var _source_logic = require("../source_logic");
var _synchronization_sub_nav = require("./synchronization/synchronization_sub_nav");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSourceSubNav = () => {
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const syncSubnav = (0, _synchronization_sub_nav.useSynchronizationSubNav)();
  const {
    contentSource: {
      id,
      serviceType,
      isIndexedSource,
      name
    }
  } = (0, _kea.useValues)(_source_logic.SourceLogic);
  if (!id) return undefined;
  const isCustom = serviceType === _constants.CUSTOM_SERVICE_TYPE;
  const showSynchronization = isIndexedSource && isOrganization && !isCustom;
  const navItems = [{
    id: 'sourceName',
    name: /*#__PURE__*/_react.default.createElement("strong", null, name)
  }, {
    id: 'sourceOverview',
    name: _constants.NAV.OVERVIEW,
    ...(0, _layout.generateNavLink)({
      to: (0, _routes.getContentSourcePath)(_routes.SOURCE_DETAILS_PATH, id, isOrganization)
    })
  }, {
    id: 'sourceContent',
    name: _constants.NAV.CONTENT,
    ...(0, _layout.generateNavLink)({
      to: (0, _routes.getContentSourcePath)(_routes.SOURCE_CONTENT_PATH, id, isOrganization)
    })
  }];
  if (showSynchronization) {
    navItems.push({
      id: 'sourceSynchronization',
      name: _constants.NAV.SYNCHRONIZATION,
      ...(0, _layout.generateNavLink)({
        to: (0, _routes.getContentSourcePath)(_routes.SOURCE_SYNCHRONIZATION_PATH, id, isOrganization)
      }),
      items: syncSubnav
    });
  }
  if (isCustom) {
    navItems.push({
      id: 'sourceSchema',
      name: _constants.NAV.SCHEMA,
      ...(0, _layout.generateNavLink)({
        to: (0, _routes.getContentSourcePath)(_routes.SOURCE_SCHEMAS_PATH, id, isOrganization),
        shouldShowActiveForSubroutes: true
      })
    });
    navItems.push({
      id: 'sourceDisplaySettings',
      name: _constants.NAV.DISPLAY_SETTINGS,
      ...(0, _layout.generateNavLink)({
        to: (0, _routes.getContentSourcePath)(_routes.SOURCE_DISPLAY_SETTINGS_PATH, id, isOrganization),
        shouldShowActiveForSubroutes: true
      })
    });
  }
  navItems.push({
    id: 'sourceSettings',
    name: _constants.NAV.SETTINGS,
    ...(0, _layout.generateNavLink)({
      to: (0, _routes.getContentSourcePath)(_routes.SOURCE_SETTINGS_PATH, id, isOrganization)
    })
  });
  return navItems;
};
exports.useSourceSubNav = useSourceSubNav;