"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourceSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../shared/constants");
var _react_router_helpers = require("../../../../shared/react_router_helpers");
var _app_logic = require("../../../app_logic");
var _content_section = require("../../../components/shared/content_section");
var _source_config_fields = require("../../../components/shared/source_config_fields");
var _view_content_header = require("../../../components/shared/view_content_header");
var _constants2 = require("../../../constants");
var _routes = require("../../../routes");
var _utils = require("../../../utils");
var _constants3 = require("../constants");
var _source_logic = require("../source_logic");
var _add_source_logic = require("./add_source/add_source_logic");
var _download_diagnostics_button = require("./download_diagnostics_button");
var _source_layout = require("./source_layout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SourceSettings = () => {
  const {
    updateContentSource,
    removeContentSource,
    setStagedPrivateKey,
    updateContentSourceConfiguration
  } = (0, _kea.useActions)(_source_logic.SourceLogic);
  const {
    contentSource: {
      name,
      id,
      serviceType,
      isOauth1,
      secret
    },
    buttonLoading,
    stagedPrivateKey,
    isConfigurationUpdateButtonLoading
  } = (0, _kea.useValues)(_source_logic.SourceLogic);

  // Even though SourceLogic.values.contentSource.serviceType is retrieved async
  // by SourceLogic, it will always be defined by the time this view is rendered
  // because it is not displayed until SourceLogic has retrieved the content source and
  // SourceLogic.values.dataLoading === false
  const addSourceLogic = (0, _add_source_logic.AddSourceLogic)({
    serviceType
  });
  const {
    getSourceConfigData
  } = (0, _kea.useActions)(addSourceLogic);
  const {
    sourceConfigData,
    dataLoading
  } = (0, _kea.useValues)(addSourceLogic);
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  (0, _react.useEffect)(() => {
    getSourceConfigData();
  }, []);
  const isGithubApp = serviceType === _constants2.GITHUB_VIA_APP_SERVICE_TYPE || serviceType === _constants2.GITHUB_ENTERPRISE_SERVER_VIA_APP_SERVICE_TYPE;
  const isCustomSource = serviceType === 'custom';
  const editPath = isGithubApp ? undefined // undefined for GitHub apps, as they are configured source-wide, and don't use a connector where you can edit the configuration
  : (0, _routes.getEditPath)(serviceType);
  const [inputValue, setValue] = (0, _react.useState)(name);
  const [confirmModalVisible, setModalVisibility] = (0, _react.useState)(false);
  const showConfirm = () => setModalVisibility(true);
  const hideConfirm = () => setModalVisibility(false);
  const showSourceConfig = !isGithubApp && !isCustomSource && isOrganization;
  const showGithubAppConfig = isGithubApp;
  const handleNameChange = e => setValue(e.target.value);
  const submitNameChange = e => {
    e.preventDefault();
    updateContentSource(id, {
      name: inputValue
    });
  };
  const submitConfigurationChange = e => {
    e.preventDefault();
    updateContentSourceConfiguration(id, {
      private_key: stagedPrivateKey
    });
  };
  const handleSourceRemoval = () => {
    /**
     * The modal was just hanging while the UI waited for the server to respond.
     * EuiModal doens't allow the button to have a loading state so we just hide the
     * modal here and set the button that was clicked to delete to a loading state.
     */
    setModalVisibility(false);
    removeContentSource(id);
  };
  const confirmModal = /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _constants2.CONFIRM_MODAL_TITLE,
    onConfirm: handleSourceRemoval,
    onCancel: hideConfirm,
    buttonColor: "danger",
    cancelButtonText: _constants2.CANCEL_BUTTON,
    confirmButtonText: _constants2.OK_BUTTON,
    defaultFocusedButton: "confirm"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.workplaceSearch.sources.settingsModal.text",
    defaultMessage: "Your source documents will be deleted from Workplace Search.{lineBreak}Are you sure you want to remove {name}?",
    values: {
      name,
      lineBreak: /*#__PURE__*/_react.default.createElement("br", null)
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_source_layout.SourceLayout, {
    pageChrome: [_constants2.NAV.SETTINGS],
    pageViewTelemetry: "source_settings",
    isLoading: dataLoading
  }, /*#__PURE__*/_react.default.createElement(_view_content_header.ViewContentHeader, {
    title: _constants3.SOURCE_SETTINGS_HEADING
  }), /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, {
    title: _constants3.SOURCE_SETTINGS_TITLE,
    description: _constants3.SOURCE_SETTINGS_DESCRIPTION
  }, /*#__PURE__*/_react.default.createElement("form", {
    onSubmit: submitNameChange
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: inputValue,
    size: 64,
    onChange: handleNameChange,
    "aria-label": _constants3.SOURCE_NAME_LABEL,
    disabled: buttonLoading,
    "data-test-subj": "SourceNameInput"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: buttonLoading,
    color: "primary",
    onClick: submitNameChange,
    "data-test-subj": "SaveChangesButton"
  }, _constants2.SAVE_CHANGES_BUTTON))))), showSourceConfig && /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, {
    title: _constants3.SOURCE_CONFIG_TITLE
  }, /*#__PURE__*/_react.default.createElement(_source_config_fields.SourceConfigFields, {
    isOauth1: isOauth1,
    sourceConfigData: sourceConfigData
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonEmptyTo, {
    to: editPath,
    flush: "left"
  }, _constants3.SOURCE_CONFIG_LINK))), showGithubAppConfig && /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, {
    title: _constants3.SOURCE_CONFIG_TITLE
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    onSubmit: submitConfigurationChange
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "GitHub App ID"
  }, /*#__PURE__*/_react.default.createElement("div", null, secret.app_id)), secret.base_url && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Base URL"
  }, /*#__PURE__*/_react.default.createElement("div", null, secret.base_url)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: "Private key"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", null, "SHA256:", secret.fingerprint), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    key: secret.fingerprint // clear staged file by rerendering the file picker each time the fingerprint changes
    ,
    onChange: files => (0, _utils.handlePrivateKeyUpload)(files, setStagedPrivateKey),
    initialPromptText: _i18n.i18n.translate('xpack.enterpriseSearch.workplaceSearch.sources.sourceSettings.pemKeyPrompText', {
      defaultMessage: 'Upload a new .pem file to rotate the private key'
    }),
    accept: ".pem"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    type: "submit",
    isLoading: isConfigurationUpdateButtonLoading,
    disabled: !stagedPrivateKey
  }, _constants.SAVE_BUTTON_LABEL))), /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, {
    title: _constants3.SYNC_DIAGNOSTICS_TITLE,
    description: _constants3.SYNC_DIAGNOSTICS_DESCRIPTION
  }, /*#__PURE__*/_react.default.createElement(_download_diagnostics_button.DownloadDiagnosticsButton, {
    label: _constants3.SYNC_DIAGNOSTICS_BUTTON
  })), /*#__PURE__*/_react.default.createElement(_content_section.ContentSection, {
    title: _constants3.SOURCE_REMOVE_TITLE,
    description: _constants3.SOURCE_REMOVE_DESCRIPTION
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isLoading: buttonLoading,
    "data-test-subj": "DeleteSourceButton",
    fill: true,
    color: "danger",
    onClick: showConfirm
  }, _constants2.REMOVE_BUTTON), confirmModalVisible && confirmModal));
};
exports.SourceSettings = SourceSettings;