"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddSourceIntro = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _kibana = require("../../../../../shared/kibana");
var _licensing = require("../../../../../shared/licensing");
var _app_logic = require("../../../../app_logic");
var _layout = require("../../../../components/layout");
var _constants = require("../../../../constants");
var _routes = require("../../../../routes");
var _source_data = require("../../source_data");
var _add_source_header = require("./add_source_header");
var _configuration_intro = require("./configuration_intro");
require("./add_source.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddSourceIntro = () => {
  const {
    serviceType
  } = (0, _reactRouterDom.useParams)();
  const sourceData = (0, _source_data.getSourceData)(serviceType);
  const {
    isOrganization
  } = (0, _kea.useValues)(_app_logic.AppLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  if (!sourceData) {
    return null;
  }
  const {
    name,
    categories = [],
    accountContextOnly
  } = sourceData;
  if (!hasPlatinumLicense && accountContextOnly) {
    navigateToUrl((0, _routes.getSourcesPath)(_routes.ADD_SOURCE_PATH, isOrganization));
  }
  const header = /*#__PURE__*/_react.default.createElement(_add_source_header.AddSourceHeader, {
    name: name,
    serviceType: serviceType,
    categories: categories
  });
  const Layout = isOrganization ? _layout.WorkplaceSearchPageTemplate : _layout.PersonalDashboardLayout;
  const to = `${(0, _routes.getSourcesPath)((0, _routes.getAddPath)(serviceType), isOrganization)}/` + ((0, _source_data.hasMultipleConnectorOptions)(serviceType) ? 'choice' : '');
  return /*#__PURE__*/_react.default.createElement(Layout, {
    pageChrome: [_constants.NAV.SOURCES, _constants.NAV.ADD_SOURCE, name]
  }, /*#__PURE__*/_react.default.createElement(_configuration_intro.ConfigurationIntro, {
    name: name,
    advanceStepTo: to,
    header: header
  }));
};
exports.AddSourceIntro = AddSourceIntro;