"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ApiKeyPanelContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _kibana = require("../../kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ApiKeyPanelContent = ({
  apiKeys,
  openApiKeyModal
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.gettingStarted.generateApiKeyPanel.apiKeytitle', {
    defaultMessage: 'Generate an API key'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.gettingStarted.generateApiKeyPanel.apiKeydesc', {
    defaultMessage: 'Your private, unique identifier for authentication and authorization.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "spaceBetween",
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    key: "viewApiKeys",
    iconType: "plusInCircle",
    onClick: openApiKeyModal,
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documementExample.generateApiKeyButton.createNew', {
    defaultMessage: 'New'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    key: "viewApiKeys",
    iconType: "popout",
    iconSide: "right",
    onClick: () => _kibana.KibanaLogic.values.navigateToUrl('/app/management/security/api_keys', {
      shouldNotCreateHref: true
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.overview.documementExample.generateApiKeyButton.viewAll', {
    defaultMessage: 'Manage'
  }))))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.apiKey.activeKeys",
    defaultMessage: "{number} active API keys.",
    values: {
      number: /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: ((apiKeys === null || apiKeys === void 0 ? void 0 : apiKeys.length) || 0) > 0 ? 'success' : 'warning',
        "data-test-subj": "api-keys-count-badge"
      }, (apiKeys === null || apiKeys === void 0 ? void 0 : apiKeys.length) || 0)
    }
  })))))))));
};
exports.ApiKeyPanelContent = ApiKeyPanelContent;