"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineSelectOptionDisabled = exports.PipelineSelectOption = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ml_model_type_badge = require("../ml_model_type_badge");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: Make disabledReason required and remove EXISTING_PIPELINE_DISABLED_MISSING_SOURCE_FIELDS call without args
const PipelineSelectOptionDisabled = ({
  disabledReason
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "warning",
    color: "warning"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "warning"
  }, disabledReason !== null && disabledReason !== void 0 ? disabledReason : _utils.EXISTING_PIPELINE_DISABLED_MISSING_SOURCE_FIELDS)));
};
exports.PipelineSelectOptionDisabled = PipelineSelectOptionDisabled;
const PipelineSelectOption = ({
  pipeline
}) => {
  const modelIdDisplay = pipeline.modelId.length > 0 ? pipeline.modelId : _utils.MODEL_REDACTED_VALUE;
  return (
    /*#__PURE__*/
    // TODO: Add model state & pipeline info link. Make sure to check mobile rendering when doing this!
    _react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "xs"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, pipeline.pipelineName))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      justifyContent: "flexStart",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: pipeline.modelType.length === 0
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, modelIdDisplay)), pipeline.modelType.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_ml_model_type_badge.MLModelTypeBadge, {
      type: pipeline.modelType
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, pipeline.disabled ? /*#__PURE__*/_react.default.createElement(PipelineSelectOptionDisabled, {
      disabledReason: pipeline.disabledReason
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, pipeline.sourceFields.join(', '))))
  );
};
exports.PipelineSelectOption = PipelineSelectOption;