"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineSelect = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _ml_inference_logic = require("./ml_inference_logic");
var _pipeline_select_option = require("./pipeline_select_option");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineSelect = () => {
  const {
    addInferencePipelineModal: {
      configuration
    },
    existingInferencePipelines
  } = (0, _kea.useValues)(_ml_inference_logic.MLInferenceLogic);
  const {
    selectExistingPipeline
  } = (0, _kea.useActions)(_ml_inference_logic.MLInferenceLogic);
  const {
    pipelineName
  } = configuration;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const largeScreenRowHeight = euiTheme.base * 6;
  const smallScreenRowHeight = euiTheme.base * 8;
  const maxVisibleOptions = 4.5;
  const rowHeight = (0, _eui.useIsWithinMaxBreakpoint)('s') ? smallScreenRowHeight : largeScreenRowHeight;
  const [height, setHeight] = (0, _react.useState)(maxVisibleOptions * rowHeight);
  const getPipelineOptions = pipelineOptions => {
    return pipelineOptions.map(pipelineOption => ({
      checked: pipelineOption.pipelineName === pipelineName ? 'on' : undefined,
      disabled: pipelineOption.disabled,
      label: pipelineOption.pipelineName,
      pipeline: pipelineOption
    }));
  };
  const renderPipelineOption = option => {
    return /*#__PURE__*/_react.default.createElement(_pipeline_select_option.PipelineSelectOption, option);
  };
  const onChange = options => {
    const selectedOption = options.find(option => option.checked === 'on');
    if (selectedOption) {
      selectExistingPipeline(selectedOption.pipeline.pipelineName);
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    options: getPipelineOptions(existingInferencePipelines),
    listProps: {
      bordered: true,
      showIcons: true,
      onFocusBadge: false,
      rowHeight
    },
    searchProps: {
      onChange: (_, matchingOptions) => {
        setHeight(Math.min(maxVisibleOptions, matchingOptions.length) * rowHeight);
      }
    },
    searchable: true,
    singleSelection: "always",
    onChange: onChange,
    renderOption: renderPipelineOption,
    height: height
  }, (list, search) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, search, list));
};
exports.PipelineSelect = PipelineSelect;