"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NoModelsPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _no_ml_models_dark = _interopRequireDefault(require("../../../../../../assets/images/no_ml_models_dark.svg"));
var _no_ml_models_light = _interopRequireDefault(require("../../../../../../assets/images/no_ml_models_light.svg"));
var _doc_links = require("../../../../../shared/doc_links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NoModelsPanel = () => {
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "xl",
      src: colorMode === 'LIGHT' ? _no_ml_models_light.default : _no_ml_models_dark.default,
      alt: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.noModels.imageAlt', {
        defaultMessage: 'No machine learning models illustration'
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.noModels.description",
      defaultMessage: "You have no trained machine learning models that can be used by an inference pipeline. {documentationLink}",
      values: {
        documentationLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: _doc_links.docLinks.machineLearningStart,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.addInferencePipelineModal.noModels.esDocs.link', {
          defaultMessage: 'Learn how to add a trained model'
        }))
      }
    }))))
  });
};
exports.NoModelsPanel = NoModelsPanel;