"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlerConfigurationLogic = void 0;
var _kea = require("kea");
var _update_html_extraction_api_logic = require("../../../../api/crawler/update_html_extraction_api_logic");
var _indices = require("../../../../utils/indices");
var _index_view_logic = require("../../index_view_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlerConfigurationLogic = (0, _kea.kea)({
  actions: {
    updateHtmlExtraction: htmlExtraction => ({
      htmlExtraction
    })
  },
  connect: {
    actions: [_index_view_logic.IndexViewLogic, ['fetchIndex', 'fetchIndexApiSuccess'], _update_html_extraction_api_logic.UpdateHtmlExtractionApiLogic, ['apiSuccess', 'makeRequest']],
    values: [_index_view_logic.IndexViewLogic, ['connector', 'indexName'], _update_html_extraction_api_logic.UpdateHtmlExtractionApiLogic, ['status']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    apiSuccess: () => {
      actions.fetchIndex();
    },
    updateHtmlExtraction: ({
      htmlExtraction
    }) => {
      actions.makeRequest({
        htmlExtraction,
        indexName: values.indexName
      });
    }
  }),
  path: ['enterprise_search', 'search_index', 'crawler', 'configuration'],
  reducers: {
    localHtmlExtraction: [null, {
      apiSuccess: (_, {
        htmlExtraction
      }) => htmlExtraction,
      fetchIndexApiSuccess: (_, index) => {
        if ((0, _indices.isCrawlerIndex)(index)) {
          var _index$connector$conf, _index$connector$conf2;
          return (_index$connector$conf = (_index$connector$conf2 = index.connector.configuration.extract_full_html) === null || _index$connector$conf2 === void 0 ? void 0 : _index$connector$conf2.value) !== null && _index$connector$conf !== void 0 ? _index$connector$conf : null;
        }
        return null;
      }
    }]
  },
  selectors: ({
    selectors
  }) => ({
    htmlExtraction: [() => [selectors.connector, selectors.localHtmlExtraction], (connector, localHtmlExtraction) => {
      var _connector$configurat, _connector$configurat2;
      return localHtmlExtraction !== null ? localHtmlExtraction : (_connector$configurat = connector === null || connector === void 0 ? void 0 : (_connector$configurat2 = connector.configuration.extract_full_html) === null || _connector$configurat2 === void 0 ? void 0 : _connector$configurat2.value) !== null && _connector$configurat !== void 0 ? _connector$configurat : false;
    }]
  })
});
exports.CrawlerConfigurationLogic = CrawlerConfigurationLogic;