"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlCustomSettingsFlyoutSeedUrlsPanelWithLogicProps = exports.CrawlCustomSettingsFlyoutSeedUrlsPanel = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _simplified_selectable = require("../../../../../shared/simplified_selectable/simplified_selectable");
var _url_combo_box = require("../../../../../shared/url_combo_box/url_combo_box");
var _crawl_custom_settings_flyout_logic = require("./crawl_custom_settings_flyout_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlCustomSettingsFlyoutSeedUrlsPanelWithLogicProps = () => {
  const {
    customEntryPointUrls,
    customSitemapUrls,
    entryPointUrls,
    includeSitemapsInRobotsTxt,
    selectedDomainUrls,
    selectedEntryPointUrls,
    selectedSitemapUrls,
    sitemapUrls
  } = (0, _kea.useValues)(_crawl_custom_settings_flyout_logic.CrawlCustomSettingsFlyoutLogic);
  const {
    onSelectCustomEntryPointUrls,
    onSelectCustomSitemapUrls,
    onSelectEntryPointUrls,
    onSelectSitemapUrls,
    toggleIncludeSitemapsInRobotsTxt
  } = (0, _kea.useActions)(_crawl_custom_settings_flyout_logic.CrawlCustomSettingsFlyoutLogic);
  const scheduleConfig = {
    customEntryPointUrls,
    customSitemapUrls,
    includeSitemapsInRobotsTxt,
    selectedDomainUrls,
    selectedEntryPointUrls,
    selectedSitemapUrls,
    entryPointUrls,
    sitemapUrls
  };
  return /*#__PURE__*/_react.default.createElement(CrawlCustomSettingsFlyoutSeedUrlsPanel, {
    scheduleConfig: scheduleConfig,
    onSelectCustomEntryPointUrls: onSelectCustomEntryPointUrls,
    onSelectCustomSitemapUrls: onSelectCustomSitemapUrls,
    onSelectEntryPointUrls: onSelectEntryPointUrls,
    onSelectSitemapUrls: onSelectSitemapUrls,
    toggleIncludeSitemapsInRobotsTxt: toggleIncludeSitemapsInRobotsTxt
  });
};
exports.CrawlCustomSettingsFlyoutSeedUrlsPanelWithLogicProps = CrawlCustomSettingsFlyoutSeedUrlsPanelWithLogicProps;
const CrawlCustomSettingsFlyoutSeedUrlsPanel = ({
  scheduleConfig,
  onSelectCustomEntryPointUrls,
  onSelectCustomSitemapUrls,
  onSelectEntryPointUrls,
  onSelectSitemapUrls,
  toggleIncludeSitemapsInRobotsTxt
}) => {
  const totalSeedUrls = scheduleConfig.customEntryPointUrls.length + scheduleConfig.customSitemapUrls.length + scheduleConfig.selectedEntryPointUrls.length + scheduleConfig.selectedSitemapUrls.length;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: (0, _eui.useGeneratedHtmlId)({
      prefix: 'seedUrlAccordion'
    }),
    initialIsOpen: true,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      responsive: false,
      gutterSize: "s",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "globe"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.seedUrlsAccordionButtonLabel', {
      defaultMessage: 'Seed URLs'
    }))))),
    extraAction: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiNotificationBadge, {
      size: "m",
      color: totalSeedUrls > 0 ? 'accent' : 'subdued'
    }, totalSeedUrls), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.selectedDescriptor', {
      defaultMessage: 'selected'
    })))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    expand: true,
    tabs: [{
      id: (0, _eui.useGeneratedHtmlId)({
        prefix: 'sitemapsTab'
      }),
      name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.sitemapsTabLabel', {
        defaultMessage: 'Sitemaps'
      }),
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
        color: "subdued",
        borderRadius: "none",
        hasShadow: false,
        paddingSize: "s"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
        "data-telemetry-id": "entSearchContent-crawler-customCrawlSettings-includeRobotsSitemaps",
        id: (0, _eui.useGeneratedHtmlId)({
          prefix: 'includeRobotsCheckbox'
        }),
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.includeSitemapsCheckboxLabel",
          defaultMessage: "Include sitemaps discovered in {robotsDotTxt}",
          values: {
            robotsDotTxt: /*#__PURE__*/_react.default.createElement("strong", null, "robots.txt") // this is a technical term and shouldn't be translated
          }
        }),

        checked: scheduleConfig.includeSitemapsInRobotsTxt,
        onChange: toggleIncludeSitemapsInRobotsTxt
      })), /*#__PURE__*/_react.default.createElement(_simplified_selectable.SimplifiedSelectable, {
        "data-telemetry-id": "entSearchContent-crawler-customCrawlSettings-selectDomain",
        options: scheduleConfig.sitemapUrls,
        selectedOptions: scheduleConfig.selectedSitemapUrls,
        onChange: onSelectSitemapUrls,
        emptyMessage: scheduleConfig.selectedDomainUrls.length === 0 ? _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.emptyDomainsMessage', {
          defaultMessage: 'Please select a domain.'
        }) : undefined
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_url_combo_box.UrlComboBox, {
        "data-telemetry-id": "entSearchContent-crawler-customCrawlSettings-customSitemapUrls",
        label: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.customSitemapUrlsTextboxLabel', {
          defaultMessage: 'Custom sitemap URLs'
        }),
        onChange: onSelectCustomSitemapUrls,
        selectedUrls: scheduleConfig.customSitemapUrls
      }))
    }, {
      id: (0, _eui.useGeneratedHtmlId)({
        prefix: 'entryPointsTab'
      }),
      name: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.entryPointsTabLabel', {
        defaultMessage: 'Entry points'
      }),
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_simplified_selectable.SimplifiedSelectable, {
        "data-telemetry-id": "entSearchContent-crawler-customCrawlSettings-selectDomain",
        options: scheduleConfig.entryPointUrls,
        selectedOptions: scheduleConfig.selectedEntryPointUrls,
        onChange: onSelectEntryPointUrls,
        emptyMessage: scheduleConfig.selectedDomainUrls.length === 0 ? _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.emptyDomainsMessage', {
          defaultMessage: 'Please select a domain.'
        }) : undefined
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_url_combo_box.UrlComboBox, {
        "data-telemetry-id": "entSearchContent-crawler-customCrawlSettings-customEntryPointUrls",
        label: _i18n.i18n.translate('xpack.enterpriseSearch.crawler.crawlCustomSettingsFlyout.customEntryPointUrlsTextboxLabel', {
          defaultMessage: 'Custom entry point URLs'
        }),
        onChange: onSelectCustomEntryPointUrls,
        selectedUrls: scheduleConfig.customEntryPointUrls
      }))
    }],
    autoFocus: "selected"
  })));
};
exports.CrawlCustomSettingsFlyoutSeedUrlsPanel = CrawlCustomSettingsFlyoutSeedUrlsPanel;