"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterSeedUrlsByDomainUrls = exports.CrawlCustomSettingsFlyoutLogic = void 0;
var _kea = require("kea");
var _types = require("../../../../api/crawler/types");
var _crawler_logic = require("../crawler_logic");
var _utils = require("../domain_management/add_domain/utils");
var _crawl_custom_settings_flyout_domain_logic = require("./crawl_custom_settings_flyout_domain_logic");
var _crawl_custom_settings_flyout_multi_crawl_logic = require("./crawl_custom_settings_flyout_multi_crawl_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const filterSeedUrlsByDomainUrls = (seedUrls, domainUrls) => {
  const domainUrlMap = domainUrls.reduce((acc, domainUrl) => ({
    ...acc,
    [domainUrl]: true
  }), {});
  return seedUrls.filter(seedUrl => {
    const {
      domain
    } = (0, _utils.extractDomainAndEntryPointFromUrl)(seedUrl);
    return !!domainUrlMap[domain];
  });
};
exports.filterSeedUrlsByDomainUrls = filterSeedUrlsByDomainUrls;
const CrawlCustomSettingsFlyoutLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'crawler', 'crawl_custom_settings_flyout_logic'],
  connect: {
    actions: [_crawler_logic.CrawlerLogic, ['startCrawl'], _crawl_custom_settings_flyout_domain_logic.CrawlCustomSettingsFlyoutDomainConfigLogic, ['fetchDomainConfigData', 'onRecieveDomainConfigData'], _crawl_custom_settings_flyout_multi_crawl_logic.CrawlCustomSettingsFlyoutMultiCrawlLogic, ['fetchCustomScheduling', 'postCustomScheduling']],
    values: [_crawl_custom_settings_flyout_domain_logic.CrawlCustomSettingsFlyoutDomainConfigLogic, ['domainConfigs', 'domainConfigMap']]
  },
  actions: () => ({
    saveCustomSchedulingConfiguration: true,
    hideFlyout: true,
    onSelectCrawlType: crawlType => ({
      crawlType
    }),
    onSelectCustomEntryPointUrls: entryPointUrls => ({
      entryPointUrls
    }),
    onSelectCustomSitemapUrls: sitemapUrls => ({
      sitemapUrls
    }),
    onSelectDomainUrls: domainUrls => ({
      domainUrls
    }),
    onSelectEntryPointUrls: entryPointUrls => ({
      entryPointUrls
    }),
    onSelectMaxCrawlDepth: maxCrawlDepth => ({
      maxCrawlDepth
    }),
    onSelectSitemapUrls: sitemapUrls => ({
      sitemapUrls
    }),
    startCustomCrawl: true,
    toggleIncludeSitemapsInRobotsTxt: true,
    showFlyout: true
  }),
  reducers: () => ({
    crawlType: [_types.CustomCrawlType.ONE_TIME, {
      onSelectCrawlType: (_, {
        crawlType
      }) => crawlType
    }],
    customEntryPointUrls: [[], {
      showFlyout: () => [],
      onSelectCustomEntryPointUrls: (_, {
        entryPointUrls
      }) => entryPointUrls
    }],
    customSitemapUrls: [[], {
      showFlyout: () => [],
      onSelectCustomSitemapUrls: (_, {
        sitemapUrls
      }) => sitemapUrls
    }],
    includeSitemapsInRobotsTxt: [true, {
      showFlyout: () => true,
      toggleIncludeSitemapsInRobotsTxt: includeSitemapsInRobotsTxt => !includeSitemapsInRobotsTxt
    }],
    isDataLoading: [true, {
      showFlyout: () => true,
      onRecieveDomainConfigData: () => false
    }],
    isFormSubmitting: [false, {
      startCustomCrawl: () => true,
      startCrawl: () => false
    }],
    isFlyoutVisible: [false, {
      showFlyout: () => true,
      hideFlyout: () => false,
      startCrawl: () => false,
      saveCustomSchedulingConfiguration: () => false
    }],
    maxCrawlDepth: [2, {
      showFlyout: () => 2,
      onSelectMaxCrawlDepth: (_, {
        maxCrawlDepth
      }) => maxCrawlDepth
    }],
    selectedDomainUrls: [[], {
      showFlyout: () => [],
      onSelectDomainUrls: (_, {
        domainUrls
      }) => domainUrls
    }],
    selectedEntryPointUrls: [[], {
      showFlyout: () => [],
      onSelectEntryPointUrls: (_, {
        entryPointUrls
      }) => entryPointUrls,
      onSelectDomainUrls: (entryPointUrls, {
        domainUrls
      }) => filterSeedUrlsByDomainUrls(entryPointUrls, domainUrls)
    }],
    selectedSitemapUrls: [[], {
      showFlyout: () => [],
      onSelectSitemapUrls: (_, {
        sitemapUrls
      }) => sitemapUrls,
      onSelectDomainUrls: (selectedSitemapUrls, {
        domainUrls
      }) => filterSeedUrlsByDomainUrls(selectedSitemapUrls, domainUrls)
    }]
  }),
  selectors: () => ({
    entryPointUrls: [selectors => [_crawl_custom_settings_flyout_domain_logic.CrawlCustomSettingsFlyoutDomainConfigLogic.selectors.domainConfigMap, selectors.selectedDomainUrls], (domainConfigMap, selectedDomainUrls) => selectedDomainUrls.flatMap(selectedDomainUrl => domainConfigMap[selectedDomainUrl].seedUrls)],
    isSingleCrawlType: [selectors => [selectors.crawlType], crawlType => crawlType === _types.CustomCrawlType.ONE_TIME],
    sitemapUrls: [selectors => [_crawl_custom_settings_flyout_domain_logic.CrawlCustomSettingsFlyoutDomainConfigLogic.selectors.domainConfigMap, selectors.selectedDomainUrls], (domainConfigMap, selectedDomainUrls) => selectedDomainUrls.flatMap(selectedDomainUrl => domainConfigMap[selectedDomainUrl].sitemapUrls)]
  }),
  listeners: ({
    actions,
    values
  }) => ({
    showFlyout: async () => {
      actions.fetchDomainConfigData();
      actions.fetchCustomScheduling();
    },
    saveCustomSchedulingConfiguration: () => {
      actions.postCustomScheduling();
    },
    startCustomCrawl: () => {
      const overrides = {
        sitemap_discovery_disabled: !values.includeSitemapsInRobotsTxt,
        max_crawl_depth: values.maxCrawlDepth,
        domain_allowlist: values.selectedDomainUrls
      };
      const seedUrls = [...values.selectedEntryPointUrls, ...values.customEntryPointUrls];
      if (seedUrls.length > 0) {
        overrides.seed_urls = seedUrls;
      }
      const sitemapUrls = [...values.selectedSitemapUrls, ...values.customSitemapUrls];
      if (sitemapUrls.length > 0) {
        overrides.sitemap_urls = sitemapUrls;
      }
      actions.startCrawl(overrides);
    }
  })
});
exports.CrawlCustomSettingsFlyoutLogic = CrawlCustomSettingsFlyoutLogic;