"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NativeConnectorConfigurationConfig = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _searchConnectors = require("@kbn/search-connectors");
var _connector_configuration = require("@kbn/search-connectors/components/configuration/connector_configuration");
var _api = require("../../../../../../../common/types/api");
var _doc_links = require("../../../../../shared/doc_links");
var _http = require("../../../../../shared/http");
var _licensing = require("../../../../../shared/licensing");
var _update_connector_configuration_api_logic = require("../../../../api/connector/update_connector_configuration_api_logic");
var _index_name_logic = require("../../index_name_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NativeConnectorConfigurationConfig = ({
  connector,
  nativeConnector,
  status
}) => {
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    status: updateStatus
  } = (0, _kea.useValues)(_update_connector_configuration_api_logic.ConnectorConfigurationApiLogic);
  const {
    makeRequest
  } = (0, _kea.useActions)(_update_connector_configuration_api_logic.ConnectorConfigurationApiLogic);
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  return /*#__PURE__*/_react.default.createElement(_connector_configuration.ConnectorConfigurationComponent, {
    connector: connector,
    hasPlatinumLicense: hasPlatinumLicense,
    isLoading: updateStatus === _api.Status.LOADING,
    saveConfig: configuration => makeRequest({
      configuration,
      connectorId: connector.id,
      indexName
    }),
    subscriptionLink: _doc_links.docLinks.licenseManagement,
    stackManagementLink: http.basePath.prepend('/app/management/stack/license_management')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.config.encryptionWarningMessage', {
    defaultMessage: 'Encryption for data source credentials is unavailable in this version. Your data source credentials will be stored, unencrypted, in Elasticsearch.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.elasticsearchSecureCluster,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.config.securityDocumentationLinkLabel', {
    defaultMessage: 'Learn more about Elasticsearch security'
  }))), nativeConnector.externalAuthDocsUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: nativeConnector.externalAuthDocsUrl,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.config.sourceSecurityDocumentationLinkLabel', {
    defaultMessage: '{name} authentication',
    values: {
      name: nativeConnector.name
    }
  })))), status === _searchConnectors.ConnectorStatus.CONNECTED && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    iconType: "check",
    color: "success",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.connectorConnected', {
      defaultMessage: 'Your connector {name} has connected to Search successfully.',
      values: {
        name: nativeConnector.name
      }
    })
  })));
};
exports.NativeConnectorConfigurationConfig = NativeConnectorConfigurationConfig;