"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseConnectorFilter = exports.SelectConnector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _react2 = require("@emotion/react");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _network_drive = _interopRequireDefault(require("../../../../../assets/source_icons/network_drive.svg"));
var _constants2 = require("../../../../shared/constants");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _kibana = require("../../../../shared/kibana");
var _licensing = require("../../../../shared/licensing");
var _query_params = require("../../../../shared/query_params");
var _routes = require("../../../routes");
var _layout = require("../../layout");
var _constants3 = require("../../search_index/connector/constants");
var _search_indices = require("../../search_indices");
var _connector_checkable = require("./connector_checkable");
var _connector_description_badge_popout = require("./connector_description_badge_popout");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseConnectorFilter = filter => {
  const temp = Array.isArray(filter) ? filter[0] : filter !== null && filter !== void 0 ? filter : null;
  if (!temp) return null;
  if (temp === _constants.CONNECTOR_CLIENTS_TYPE) {
    return _constants.CONNECTOR_CLIENTS_TYPE;
  }
  if (temp === _constants.CONNECTOR_NATIVE_TYPE) {
    return _constants.CONNECTOR_NATIVE_TYPE;
  }
  return null;
};
exports.parseConnectorFilter = parseConnectorFilter;
const SelectConnector = () => {
  const {
    search
  } = (0, _reactRouterDom.useLocation)();
  const {
    isCloud
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const hasNativeAccess = isCloud;
  const {
    filter
  } = (0, _query_params.parseQueryParams)(search);
  const [selectedConnectorFilter, setSelectedConnectorFilter] = (0, _react.useState)(parseConnectorFilter(filter));
  const useNativeFilter = selectedConnectorFilter === _constants.CONNECTOR_NATIVE_TYPE;
  const useClientsFilter = selectedConnectorFilter === _constants.CONNECTOR_CLIENTS_TYPE;
  const [showTechPreview, setShowTechPreview] = (0, _react.useState)(true);
  const [showBeta, setShowBeta] = (0, _react.useState)(true);
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const filteredConnectors = (0, _react.useMemo)(() => {
    const nativeConnectors = hasNativeAccess ? _constants3.CONNECTORS.filter(connector => connector.isNative).sort((a, b) => a.name.localeCompare(b.name)) : [];
    const nonNativeConnectors = hasNativeAccess ? _constants3.CONNECTORS.filter(connector => !connector.isNative).sort((a, b) => a.name.localeCompare(b.name)) : _constants3.CONNECTORS.sort((a, b) => a.name.localeCompare(b.name));
    const connectors = !hasNativeAccess || useClientsFilter ? _constants3.CONNECTORS.sort((a, b) => a.name.localeCompare(b.name)) : [...nativeConnectors, ...nonNativeConnectors];
    return connectors.filter(connector => showBeta ? true : !connector.isBeta).filter(connector => showTechPreview ? true : !connector.isTechPreview).filter(connector => useNativeFilter ? connector.isNative : true).filter(connector => searchTerm ? connector.name.toLowerCase().includes(searchTerm.toLowerCase()) : true);
  }, [hasNativeAccess, useClientsFilter, showBeta, showTechPreview, useNativeFilter, searchTerm]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_layout.EnterpriseSearchContentPageTemplate, {
    pageChrome: [..._search_indices.baseBreadcrumbs, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.breadcrumb', {
      defaultMessage: 'Select connector'
    })],
    pageViewTelemetry: "select_connector",
    isLoading: false,
    pageHeader: {
      description: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.description', {
        defaultMessage: "Choose which third-party data source you'd like to sync to Elastic."
      }),
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.title', {
        defaultMessage: 'Select a connector'
      })
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
            max-width: calc(${euiTheme.size.xxl} * 5);
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFacetGroup, null, hasNativeAccess && /*#__PURE__*/_react.default.createElement(_eui.EuiFacetButton, {
    quantity: _constants3.CONNECTORS.length,
    isSelected: !useNativeFilter && !useClientsFilter,
    onClick: () => setSelectedConnectorFilter(null)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.allConnectorsLabel', {
    defaultMessage: 'All connectors'
  })), hasNativeAccess && /*#__PURE__*/_react.default.createElement(_eui.EuiFacetButton, {
    key: "native",
    quantity: _constants3.CONNECTORS.filter(connector => connector.isNative).length,
    isSelected: useNativeFilter,
    onClick: () => setSelectedConnectorFilter(!useNativeFilter ? _constants.CONNECTOR_NATIVE_TYPE : null)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.nativeLabel', {
    defaultMessage: 'Native connectors'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFacetButton, {
    quantity: _constants3.CONNECTORS.length,
    isSelected: !hasNativeAccess && !useNativeFilter || useClientsFilter,
    onClick: () => setSelectedConnectorFilter(!useClientsFilter ? _constants.CONNECTOR_CLIENTS_TYPE : null)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.connectorClients', {
    defaultMessage: 'Connector clients'
  })), !hasNativeAccess && /*#__PURE__*/_react.default.createElement(_eui.EuiFacetButton, {
    key: "native",
    quantity: _constants3.CONNECTORS.filter(connector => connector.isNative).length,
    isSelected: useNativeFilter,
    onClick: () => setSelectedConnectorFilter(!useNativeFilter ? _constants.CONNECTOR_NATIVE_TYPE : null)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.nativeLabel', {
    defaultMessage: 'Native connectors'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: showBeta,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.showBetaLabel', {
      defaultMessage: 'Display Beta connectors'
    }),
    onChange: e => setShowBeta(e.target.checked)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: showTechPreview,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.showTechPreviewLabel', {
      defaultMessage: 'Display Tech Preview connectors'
    }),
    onChange: e => setShowTechPreview(e.target.checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "logoCloud"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.selectConnector.nativeConnectorsTitleLabel', {
    defaultMessage: 'Native connectors'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_connector_description_badge_popout.ConnectorDescriptionBadge, {
    isNative: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.selectConnector.p.areAvailableDirectlyWithinLabel', {
    defaultMessage: 'Available directly within Elastic Cloud deployments. No additional infrastructure is required. You can also convert native connectors to self-hosted connector clients.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "s",
    hasShadow: false,
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: _network_drive.default
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.selectConnector.h4.connectorClientsLabel', {
    defaultMessage: 'Connector clients'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_connector_description_badge_popout.ConnectorDescriptionBadge, {
    isNative: false
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    grow: false
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.selectConnector.p.deployConnectorsOnYourLabel', {
    defaultMessage: 'Deploy connectors on your own infrastructure. You can also customize existing connector clients, or build your own using our connector framework.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.search.ariaLabel', {
      defaultMessage: 'Search through connectors'
    }),
    isClearable: true,
    onChange: event => setSearchTerm(event.target.value),
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.searchPlaceholder', {
      defaultMessage: 'Search'
    }),
    value: searchTerm,
    fullWidth: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3
  }, filteredConnectors.map(connector => {
    var _ref;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: connector.serviceType,
      grow: true
    }, /*#__PURE__*/_react.default.createElement(_connector_checkable.ConnectorCheckable, {
      isDisabled: (_ref = connector.platinumOnly && !(hasPlatinumLicense || isCloud) || !hasNativeAccess && useNativeFilter) !== null && _ref !== void 0 ? _ref : false,
      iconType: connector.icon,
      isBeta: connector.isBeta,
      isTechPreview: Boolean(connector.isTechPreview),
      showNativeBadge: hasNativeAccess && connector.isNative && !useClientsFilter || !hasNativeAccess && useNativeFilter,
      name: connector.name,
      serviceType: connector.serviceType,
      onConnectorSelect: isNative => {
        const queryParam = new URLSearchParams();
        queryParam.append('service_type', connector.serviceType);
        if (isNative !== undefined) {
          queryParam.append('connector_type', isNative && !useClientsFilter ? _constants.CONNECTOR_NATIVE_TYPE : _constants.CONNECTOR_CLIENTS_TYPE);
        }
        _kibana.KibanaLogic.values.navigateToUrl(`${(0, _encode_path_params.generateEncodedPath)(_routes.NEW_INDEX_METHOD_PATH, {
          type: _constants.INGESTION_METHOD_IDS.CONNECTOR
        })}?${queryParam.toString()}`);
      },
      documentationUrl: connector.docsUrl
    }));
  })), !hasNativeAccess && useNativeFilter && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "m",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.selectConnector.cloudCallout.title', {
      defaultMessage: 'Elastic Cloud'
    }),
    iconType: "iInCircle"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.indices.selectConnector.cloudCallout.description",
    defaultMessage: "Native connectors are hosted on Elastic Cloud. Get started with a free day trial."
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    fill: true,
    href: "https://www.elastic.co/cloud/cloud-trial-overview",
    iconType: "popout",
    iconSide: "right",
    target: "_blank"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.indices.selectConnector.cloudCallout.trialLink",
    defaultMessage: "Elastic Cloud Trial"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-connector-selectConnector-backButton",
    color: "primary",
    onClick: () => _kibana.KibanaLogic.values.navigateToUrl(_routes.NEW_INDEX_PATH)
  }, _constants2.BACK_BUTTON_LABEL)))))));
};
exports.SelectConnector = SelectConnector;