"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MethodCrawler = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _api = require("../../../../../../common/types/api");
var _doc_links = require("../../../../shared/doc_links");
var _http = require("../../../../shared/http");
var _kibana = require("../../../../shared/kibana");
var _licensing = require("../../../../shared/licensing");
var _licensing_callout = require("../../../../shared/licensing_callout/licensing_callout");
var _create_crawler_index_api_logic = require("../../../api/crawler/create_crawler_index_api_logic");
var _cannot_connect = require("../../search_index/components/cannot_connect");
var _new_search_index_template = require("../new_search_index_template");
var _method_crawler_logic = require("./method_crawler_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MethodCrawler = () => {
  const {
    status
  } = (0, _kea.useValues)(_create_crawler_index_api_logic.CreateCrawlerIndexApiLogic);
  const {
    makeRequest
  } = (0, _kea.useActions)(_create_crawler_index_api_logic.CreateCrawlerIndexApiLogic);
  const {
    isCloud
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http.HttpLogic);
  const isGated = !isCloud && !hasPlatinumLicense;
  _method_crawler_logic.MethodCrawlerLogic.mount();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, isGated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_licensing_callout.LicensingCallout, {
    feature: _licensing_callout.LICENSING_FEATURE.CRAWLER
  })), Boolean(errorConnectingMessage) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_cannot_connect.CannotConnect, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_new_search_index_template.NewSearchIndexTemplate, {
    type: "crawler",
    onSubmit: (indexName, language) => makeRequest({
      indexName,
      language
    }),
    disabled: isGated || Boolean(errorConnectingMessage),
    buttonLoading: status === _api.Status.LOADING,
    docsUrl: _doc_links.docLinks.crawlerOverview
  })));
};
exports.MethodCrawler = MethodCrawler;