"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorsTable = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _encode_path_params = require("../../../shared/encode_path_params");
var _kibana = require("../../../shared/kibana");
var _eui_components = require("../../../shared/react_router_helpers/eui_components");
var _routes = require("../../routes");
var _connector_status_helpers = require("../../utils/connector_status_helpers");
var _connector_type = require("./connector_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConnectorsTable = ({
  items,
  meta = {
    page: {
      from: 0,
      size: 10,
      total: 0
    }
  },
  onChange,
  isLoading
}) => {
  const {
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.connectorTable.columns.connectorName', {
      defaultMessage: 'Connector name'
    }),
    width: '25%'
  }, {
    field: 'index_name',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.connectorTable.columns.indexName', {
      defaultMessage: 'Index name'
    }),
    render: indexName => indexName ? /*#__PURE__*/_react.default.createElement(_eui_components.EuiLinkTo, {
      to: (0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_PATH, {
        indexName
      })
    }, indexName) : '--',
    width: '25%'
  }, {
    field: 'docsCount',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.connectorTable.columns.docsCount', {
      defaultMessage: 'Docs count'
    }),
    truncateText: true
  }, {
    field: 'service_type',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.connectorTable.columns.type', {
      defaultMessage: 'Connector type'
    }),
    render: serviceType => /*#__PURE__*/_react.default.createElement(_connector_type.ConnectorType, {
      serviceType: serviceType
    }),
    truncateText: true,
    width: '25%'
  }, {
    field: 'status',
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.connectorTable.columns.status', {
      defaultMessage: 'Ingestion status'
    }),
    render: connectorStatus => {
      const label = (0, _connector_status_helpers.connectorStatusToText)(connectorStatus);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: (0, _connector_status_helpers.connectorStatusToColor)(connectorStatus)
      }, label);
    },
    truncateText: true
  }, {
    actions: [{
      description: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.connectorTable.columns.actions.viewIndex', {
        defaultMessage: 'View this connector'
      }),
      enabled: connector => !!connector.index_name,
      icon: 'eye',
      isPrimary: false,
      name: connector => _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.connectorsTable.columns.actions.viewIndex.caption', {
        defaultMessage: 'View index {connectorName}',
        values: {
          connectorName: connector.name
        }
      }),
      onClick: connector => {
        navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes.SEARCH_INDEX_PATH, {
          indexName: connector.index_name || ''
        }));
      },
      type: 'icon'
    }],
    name: _i18n.i18n.translate('xpack.enterpriseSearch.content.connectors.connectorTable.columns.actions', {
      defaultMessage: 'Actions'
    })
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
    items: items,
    columns: columns,
    onChange: onChange,
    tableLayout: "fixed",
    loading: isLoading,
    pagination: {
      pageIndex: meta.page.from / (meta.page.size || 1),
      pageSize: meta.page.size,
      showPerPageOptions: false,
      totalItemCount: meta.page.total
    }
  })));
};
exports.ConnectorsTable = ConnectorsTable;