"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fetchCustomPipeline = exports.FetchCustomPipelineApiLogic = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fetchCustomPipeline = async ({
  indexName
}) => {
  const route = `/internal/enterprise_search/indices/${indexName}/pipelines`;
  const result = await _http.HttpLogic.values.http.get(route);
  return result;
};
exports.fetchCustomPipeline = fetchCustomPipeline;
const FetchCustomPipelineApiLogic = (0, _create_api_logic.createApiLogic)(['content', 'fetch_custom_pipeline_api_logic'], fetchCustomPipeline);
exports.FetchCustomPipelineApiLogic = FetchCustomPipelineApiLogic;