"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GenericConfirmationModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../shared/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GenericConfirmationModal = ({
  description,
  onClose,
  onSave,
  subheading,
  target,
  title
}) => {
  const [inputValue, setInputValue] = (0, _react.useState)('');
  const onConfirm = () => {
    setInputValue('');
    onSave();
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    onClose: onClose,
    initialFocus: ".euiFieldText",
    "aria-label": title
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, subheading)), description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.prompt', {
      defaultMessage: 'Type "{target}" to confirm.',
      values: {
        target
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    "data-test-subj": "GenericConfirmationModalInput",
    value: inputValue,
    onChange: e => setInputValue(e.target.value)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "GenericConfirmationModalCancel",
    onClick: onClose
  }, _constants.CANCEL_BUTTON_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "GenericConfirmationModalSave",
    onClick: onConfirm,
    disabled: inputValue.toLowerCase() !== target.toLowerCase()
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.modal.save', {
    defaultMessage: 'Save setting'
  }))));
};
exports.GenericConfirmationModal = GenericConfirmationModal;