"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColumnHeaders = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ColumnHeaders = () => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeader, {
    className: "resultSettingsTable__columnLabels"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    align: "left"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    align: "center",
    colSpan: 2
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.table.rawTitle', {
    defaultMessage: 'Raw'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.table.rawTooltip', {
      defaultMessage: 'A raw field is an exact representation of a field value. Must be at least 20 characters. Defaults to the entire field.'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTableHeaderCell, {
    align: "center",
    colSpan: 3
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.table.highlightingTitle', {
    defaultMessage: 'Highlighting'
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
    position: "top",
    content: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.resultSettings.table.highlightingTooltip', {
      defaultMessage: 'A snippet is an escaped representaiton of a field value. Query matches are encapsulated in <em> tags for highlighting. Fallback will look for a snippet match, but fallback to an escaped raw value if none is found. Range is between 20-1000. Defaults to 100.'
    })
  })));
};
exports.ColumnHeaders = ColumnHeaders;