"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Result = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
require("./result.scss");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../shared/kibana");
var _routes = require("../../routes");
var _encode_path_params = require("../../utils/encode_path_params");
var _results = require("../../utils/results");
var _result_field = require("./result_field");
var _result_header = require("./result_header");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RESULT_CUTOFF = 5;
const Result = ({
  result,
  isMetaEngine,
  showScore = false,
  shouldLinkToDetailPage = false,
  schemaForTypeHighlights,
  actions = [],
  dragHandleProps,
  resultPosition,
  showClick = false
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const ID = 'id';
  const META = '_meta';
  const resultMeta = result[META];
  const resultFields = (0, _react.useMemo)(() => Object.entries((0, _results.formatResultWithoutMeta)(result)).filter(([key]) => key !== ID), [result]);
  const numResults = resultFields.length;
  const isAdvancedSchema = schema => {
    return schema && Object.values(schema).reduce((isAdvanced, schemaField) => {
      return isAdvanced && typeof schemaField !== 'string';
    }, true);
  };
  const typeForField = fieldName => {
    if (schemaForTypeHighlights) {
      return isAdvancedSchema(schemaForTypeHighlights) ? schemaForTypeHighlights[fieldName].type : schemaForTypeHighlights[fieldName];
    }
  };
  const documentLink = shouldLinkToDetailPage ? (0, _encode_path_params.generateEncodedPath)(_routes.ENGINE_DOCUMENT_DETAIL_PATH, {
    engineName: resultMeta.engine,
    documentId: resultMeta.id
  }) : undefined;
  if (shouldLinkToDetailPage && documentLink) {
    const linkAction = {
      onClick: () => _kibana.KibanaLogic.values.navigateToUrl(documentLink),
      title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.result.documentDetailLink', {
        defaultMessage: 'Visit document details'
      }),
      iconType: 'eye'
    };
    actions = [linkAction, ...actions];
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    className: "appSearchResult",
    "data-test-subj": "AppSearchResult",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.result.title', {
      defaultMessage: 'Document {id}',
      values: {
        id: result[ID].raw
      }
    })
  }, dragHandleProps && /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, dragHandleProps, {
    className: "appSearchResult__dragHandle"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "grab"
  })), /*#__PURE__*/_react.default.createElement("article", {
    className: "appSearchResult__content"
  }, /*#__PURE__*/_react.default.createElement(_result_header.ResultHeader, {
    resultMeta: resultMeta,
    showScore: !!showScore,
    isMetaEngine: isMetaEngine,
    documentLink: documentLink,
    actions: actions,
    resultPosition: resultPosition,
    showClick: showClick
  }), resultFields.slice(0, isOpen ? resultFields.length : RESULT_CUTOFF).map(([field, value]) => /*#__PURE__*/_react.default.createElement(_result_field.ResultField, {
    key: field,
    field: field,
    raw: value.raw,
    snippet: value.snippet,
    type: typeForField(field)
  }))), numResults > RESULT_CUTOFF && /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    className: "appSearchResult__hiddenFieldsToggle",
    onClick: () => setIsOpen(!isOpen)
  }, isOpen ? _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.result.hideAdditionalFields', {
    defaultMessage: 'Hide additional fields'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.result.showAdditionalFields', {
    defaultMessage: 'Show {numberOfAdditionalFields, number} additional {numberOfAdditionalFields, plural, one {field} other {fields}}',
    values: {
      numberOfAdditionalFields: numResults - RESULT_CUTOFF
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: isOpen ? 'arrowUp' : 'arrowDown',
    "data-test-subj": isOpen ? 'CollapseResult' : 'ExpandResult'
  })));
};
exports.Result = Result;