"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RelevanceTuning = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../shared/constants");
var _unsaved_changes_prompt = require("../../../shared/unsaved_changes_prompt");
var _constants2 = require("../../constants");
var _engine = require("../engine");
var _layout = require("../layout");
var _components = require("./components");
var _precision_slider = require("./components/precision_slider");
var _constants3 = require("./constants");
var _relevance_tuning_callouts = require("./relevance_tuning_callouts");
var _relevance_tuning_form = require("./relevance_tuning_form");
var _relevance_tuning_preview = require("./relevance_tuning_preview");
var _ = require(".");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RelevanceTuning = () => {
  const {
    dataLoading,
    engineHasSchemaFields,
    unsavedChanges,
    isPrecisionTuningEnabled
  } = (0, _kea.useValues)(_.RelevanceTuningLogic);
  const {
    initializeRelevanceTuning,
    resetSearchSettings,
    updateSearchSettings
  } = (0, _kea.useActions)(_.RelevanceTuningLogic);
  const {
    isElasticsearchEngine
  } = (0, _kea.useValues)(_engine.EngineLogic);
  (0, _react.useEffect)(() => {
    initializeRelevanceTuning();
  }, []);
  const APP_SEARCH_MANAGED_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.description', {
    defaultMessage: 'Manage precision and relevance settings for your engine'
  });
  const ELASTICSEARCH_MANAGED_DESCRIPTION = _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engine.relevanceTuning.elasticsearch.description', {
    defaultMessage: 'Manage relevance settings for your engine'
  });
  return /*#__PURE__*/_react.default.createElement(_layout.AppSearchPageTemplate, {
    pageChrome: (0, _engine.getEngineBreadcrumbs)([_constants3.RELEVANCE_TUNING_TITLE]),
    pageHeader: {
      pageTitle: _constants3.RELEVANCE_TUNING_TITLE,
      description: isElasticsearchEngine ? ELASTICSEARCH_MANAGED_DESCRIPTION : APP_SEARCH_MANAGED_DESCRIPTION,
      rightSideItems: engineHasSchemaFields ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "SaveRelevanceTuning",
        color: "primary",
        fill: true,
        onClick: updateSearchSettings
      }, _constants.SAVE_BUTTON_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "ResetRelevanceTuning",
        color: "danger",
        onClick: resetSearchSettings
      }, _constants2.RESTORE_DEFAULTS_BUTTON_LABEL)] : []
    },
    isLoading: dataLoading,
    isEmptyState: !engineHasSchemaFields,
    emptyState: /*#__PURE__*/_react.default.createElement(_components.EmptyState, null)
  }, /*#__PURE__*/_react.default.createElement(_unsaved_changes_prompt.UnsavedChangesPrompt, {
    hasUnsavedChanges: unsavedChanges
  }), /*#__PURE__*/_react.default.createElement(_relevance_tuning_callouts.RelevanceTuningCallouts, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexStart"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), isPrecisionTuningEnabled && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_precision_slider.PrecisionSlider, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_relevance_tuning_form.RelevanceTuningForm, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 4
  }, /*#__PURE__*/_react.default.createElement(_relevance_tuning_preview.RelevanceTuningPreview, null))));
};
exports.RelevanceTuning = RelevanceTuning;