"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BoostItem = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _components = require("../components");
var _constants = require("../constants");
var _boost_item_content = require("./boost_item_content");
var _get_boost_summary = require("./get_boost_summary");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BoostItem = ({
  id,
  boost,
  index,
  name
}) => {
  const summary = (0, _react.useMemo)(() => (0, _get_boost_summary.getBoostSummary)(boost), [boost]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: id,
    className: "boosts__item",
    buttonContentClassName: "boosts__itemButton",
    initialIsOpen: !!boost.newBoost,
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_components.BoostIcon, {
      type: boost.type
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, _constants.BOOST_TYPE_TO_DISPLAY_MAP[boost.type]), /*#__PURE__*/_react.default.createElement(_eui.EuiHideFor, {
      sizes: ['xs', 's', 'm', 'l']
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "eui-textBreakAll"
    }, summary)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_components.ValueBadge, null, boost.factor))),
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_boost_item_content.BoostItemContent, {
    boost: boost,
    index: index,
    name: name
  }));
};
exports.BoostItem = BoostItem;