"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyMetaEnginesState = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _routes = require("../../../routes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyMetaEnginesState = () => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.metaEngines.emptyPromptTitle', {
    defaultMessage: 'Create your first meta engine'
  })),
  titleSize: "s",
  body: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.metaEngines.emptyPromptDescription', {
    defaultMessage: 'Meta engines allow you to combine multiple engines into one searchable engine.'
  })),
  actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    target: "_blank",
    iconType: "popout",
    href: _routes.META_ENGINES_DOCS_URL
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.metaEngines.emptyPromptButtonLabel', {
    defaultMessage: 'Learn more about meta engines'
  }))
});
exports.EmptyMetaEnginesState = EmptyMetaEnginesState;