"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlerRouter = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _routes = require("../../routes");
var _crawler_logic = require("./crawler_logic");
var _crawler_overview = require("./crawler_overview");
var _crawler_single_domain = require("./crawler_single_domain");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlerRouter = () => {
  const {
    fetchCrawlerData
  } = (0, _kea.useActions)(_crawler_logic.CrawlerLogic);
  (0, _react.useEffect)(() => {
    fetchCrawlerData();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ENGINE_CRAWLER_PATH
  }, /*#__PURE__*/_react.default.createElement(_crawler_overview.CrawlerOverview, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    exact: true,
    path: _routes.ENGINE_CRAWLER_DOMAIN_PATH
  }, /*#__PURE__*/_react.default.createElement(_crawler_single_domain.CrawlerSingleDomain, null)));
};
exports.CrawlerRouter = CrawlerRouter;