"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withLensData = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _kibana = require("../../shared/kibana");
var _find_or_create_data_view = require("../utils/find_or_create_data_view");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const withLensData = (Component, {
  dataLoadTransform,
  getAttributes,
  initialValues
}) => {
  const ComponentWithLensData = props => {
    const {
      lens: {
        EmbeddableComponent,
        stateHelperApi
      }
    } = (0, _kea.useValues)(_kibana.KibanaLogic);
    const [dataView, setDataView] = (0, _react.useState)(null);
    const [data, setData] = (0, _react.useState)(initialValues);
    const [formula, setFormula] = (0, _react.useState)(null);
    const attributes = (0, _react.useMemo)(() => dataView && formula && getAttributes(dataView, formula, props), [dataView, formula, props]);
    const handleBrushEnd = ({
      range
    }) => {
      var _props$setTimeRange;
      const [min, max] = range;
      (_props$setTimeRange = props.setTimeRange) === null || _props$setTimeRange === void 0 ? void 0 : _props$setTimeRange.call(props, {
        from: new Date(min).toISOString(),
        mode: 'absolute',
        to: new Date(max).toISOString()
      });
    };
    (0, _react.useEffect)(() => {
      (async () => {
        setDataView(await (0, _find_or_create_data_view.findOrCreateDataView)(props.collection));
      })();
    }, [props]);
    (0, _react.useEffect)(() => {
      (async () => {
        const helper = await stateHelperApi();
        setFormula(helper.formula);
      })();
    }, []);
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Component, (0, _extends2.default)({}, props, data)), attributes && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      css: {
        display: 'none'
      }
    }, /*#__PURE__*/_react.default.createElement(EmbeddableComponent, {
      id: props.id,
      timeRange: props.timeRange,
      attributes: attributes,
      searchSessionId: props === null || props === void 0 ? void 0 : props.searchSessionId,
      onBrushEnd: handleBrushEnd,
      onLoad: (isLoading, adapters) => {
        if (dataLoadTransform) {
          setData(dataLoadTransform(isLoading, adapters));
        }
      }
    })));
  };
  ComponentWithLensData.displayName = `withLensDataHOC(${Component.displayName || Component.name})`;
  return ComponentWithLensData;
};
exports.withLensData = withLensData;