"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddablePanelError = EmbeddablePanelError;
var _i18n = require("@kbn/i18n");
var _rxjs = require("rxjs");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/data-plugin/public");
var _kibana_services = require("../kibana_services");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function EmbeddablePanelError({
  editPanelAction,
  embeddable,
  error
}) {
  var _overrideDisplay$acti, _overrideDisplay$body;
  const [isEditable, setEditable] = (0, _react.useState)(false);
  const handleErrorClick = (0, _react.useMemo)(() => isEditable ? () => editPanelAction === null || editPanelAction === void 0 ? void 0 : editPanelAction.execute({
    embeddable
  }) : undefined, [editPanelAction, embeddable, isEditable]);
  const label = (0, _react.useMemo)(() => editPanelAction === null || editPanelAction === void 0 ? void 0 : editPanelAction.getDisplayName({
    embeddable
  }), [editPanelAction, embeddable]);
  const title = (0, _react.useMemo)(() => embeddable.getTitle(), [embeddable]);
  const ariaLabel = (0, _react.useMemo)(() => !title ? label : _i18n.i18n.translate('embeddableApi.panel.editPanel.displayName', {
    defaultMessage: 'Edit {value}',
    values: {
      value: title
    }
  }), [label, title]);
  const overrideDisplay = (0, _public2.getSearchErrorOverrideDisplay)({
    error,
    application: _kibana_services.core.application
  });
  const actions = (_overrideDisplay$acti = overrideDisplay === null || overrideDisplay === void 0 ? void 0 : overrideDisplay.actions) !== null && _overrideDisplay$acti !== void 0 ? _overrideDisplay$acti : [];
  if (isEditable) {
    actions.push( /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "aria-label": ariaLabel,
      onClick: handleErrorClick,
      size: "s"
    }, label));
  }
  (0, _react.useEffect)(() => {
    const subscription = (0, _rxjs.merge)(embeddable.getInput$(), embeddable.getOutput$()).pipe((0, _rxjs.switchMap)(() => {
      var _editPanelAction$isCo;
      return (_editPanelAction$isCo = editPanelAction === null || editPanelAction === void 0 ? void 0 : editPanelAction.isCompatible({
        embeddable
      })) !== null && _editPanelAction$isCo !== void 0 ? _editPanelAction$isCo : (0, _rxjs.of)(false);
    }), (0, _rxjs.distinctUntilChanged)()).subscribe(setEditable);
    return () => subscription.unsubscribe();
  }, [editPanelAction, embeddable]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    body: (_overrideDisplay$body = overrideDisplay === null || overrideDisplay === void 0 ? void 0 : overrideDisplay.body) !== null && _overrideDisplay$body !== void 0 ? _overrideDisplay$body : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_public.Markdown, {
      markdown: error.message,
      openLinksInNewTab: true,
      "data-test-subj": "errorMessageMarkdown"
    })),
    "data-test-subj": "embeddableStackError",
    iconType: "warning",
    iconColor: "danger",
    layout: "vertical",
    actions: actions
  });
}