"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKnowledgeBaseStatusRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _get_kb_resource = require("./get_kb_resource");
var _build_response = require("../../lib/build_response");
var _common = require("../../schemas/common");
var _constants = require("../../../common/constants");
var _get_knowledge_base_status = require("../../schemas/knowledge_base/get_knowledge_base_status");
var _elasticsearch_store = require("../../lib/langchain/elasticsearch_store/elasticsearch_store");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get the status of the Knowledge Base index, pipeline, and resources (collection of documents)
 *
 * @param router IRouter for registering routes
 */
const getKnowledgeBaseStatusRoute = (router, getElser) => {
  router.get({
    path: _constants.KNOWLEDGE_BASE,
    validate: {
      params: (0, _common.buildRouteValidation)(_get_knowledge_base_status.GetKnowledgeBaseStatusPathParams)
    },
    options: {
      // Note: Relying on current user privileges to scope an esClient.
      // Add `access:kbnElasticAssistant` to limit API access to only users with assistant privileges
      tags: []
    }
  }, async (context, request, response) => {
    const resp = (0, _build_response.buildResponse)(response);
    const logger = (await context.elasticAssistant).logger;
    try {
      // Get a scoped esClient for finding the status of the Knowledge Base index, pipeline, and documents
      const esClient = (await context.core).elasticsearch.client.asCurrentUser;
      const elserId = await getElser(request, (await context.core).savedObjects.getClient());
      const kbResource = (0, _get_kb_resource.getKbResource)(request);
      const esStore = new _elasticsearch_store.ElasticsearchStore(esClient, _constants2.KNOWLEDGE_BASE_INDEX_PATTERN, logger, elserId, kbResource);
      const indexExists = await esStore.indexExists();
      const pipelineExists = await esStore.pipelineExists();
      const modelExists = await esStore.isModelInstalled(elserId);
      const body = {
        elser_exists: modelExists,
        index_exists: indexExists,
        pipeline_exists: pipelineExists
      };
      if (kbResource === _constants2.ESQL_RESOURCE) {
        const esqlExists = indexExists && (await esStore.similaritySearch(_constants2.ESQL_DOCS_LOADED_QUERY)).length > 0;
        return response.ok({
          body: {
            ...body,
            esql_exists: esqlExists
          }
        });
      }
      return response.ok({
        body
      });
    } catch (err) {
      logger.error(err);
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return resp.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getKnowledgeBaseStatusRoute = getKnowledgeBaseStatusRoute;