"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteKnowledgeBaseRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _build_response = require("../../lib/build_response");
var _common = require("../../schemas/common");
var _constants = require("../../../common/constants");
var _elasticsearch_store = require("../../lib/langchain/elasticsearch_store/elasticsearch_store");
var _constants2 = require("./constants");
var _delete_knowledge_base = require("../../schemas/knowledge_base/delete_knowledge_base");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Delete Knowledge Base index, pipeline, and resources (collection of documents)
 * @param router
 */
const deleteKnowledgeBaseRoute = router => {
  router.delete({
    path: _constants.KNOWLEDGE_BASE,
    validate: {
      params: (0, _common.buildRouteValidation)(_delete_knowledge_base.DeleteKnowledgeBasePathParams)
    },
    options: {
      // Note: Relying on current user privileges to scope an esClient.
      // Add `access:kbnElasticAssistant` to limit API access to only users with assistant privileges
      tags: []
    }
  }, async (context, request, response) => {
    const resp = (0, _build_response.buildResponse)(response);
    const logger = (await context.elasticAssistant).logger;
    try {
      const kbResource = request.params.resource != null ? decodeURIComponent(request.params.resource) : undefined;

      // Get a scoped esClient for deleting the Knowledge Base index, pipeline, and documents
      const esClient = (await context.core).elasticsearch.client.asCurrentUser;
      const esStore = new _elasticsearch_store.ElasticsearchStore(esClient, _constants2.KNOWLEDGE_BASE_INDEX_PATTERN, logger);
      if (kbResource === _constants2.ESQL_RESOURCE) {
        // For now, tearing down the Knowledge Base is fine, but will want to support removing specific assets based
        // on resource name or document query
        // Implement deleteDocuments(query: string) in ElasticsearchStore
        // const success = await esStore.deleteDocuments();
        // return const body: DeleteKnowledgeBaseResponse = { success };
      }

      // Delete index and pipeline
      const indexDeleted = await esStore.deleteIndex();
      const pipelineDeleted = await esStore.deletePipeline();
      const body = {
        success: indexDeleted && pipelineDeleted
      };
      return response.ok({
        body
      });
    } catch (err) {
      logger.error(err);
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return resp.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.deleteKnowledgeBaseRoute = deleteKnowledgeBaseRoute;