"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.executeAction = void 0;
var _fp = require("lodash/fp");
var _stream = require("stream");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const executeAction = async ({
  actions,
  request,
  connectorId
}) => {
  const actionsClient = await actions.getActionsClientWithRequest(request);
  const actionResult = await actionsClient.execute({
    actionId: connectorId,
    params: request.body.params
  });
  if (actionResult.status === 'error') {
    throw new Error(`Action result status is error: ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.message} - ${actionResult === null || actionResult === void 0 ? void 0 : actionResult.serviceMessage}`);
  }
  const content = (0, _fp.get)('data.message', actionResult);
  if (typeof content === 'string') {
    return {
      connector_id: connectorId,
      data: content,
      // the response from the actions framework
      status: 'ok'
    };
  }
  const readable = (0, _fp.get)('data', actionResult);
  if (typeof (readable === null || readable === void 0 ? void 0 : readable.read) !== 'function') {
    throw new Error('Action result status is error: result is not streamable');
  }
  return readable.pipe(new _stream.PassThrough());
};
exports.executeAction = executeAction;