"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isDenied = exports.isAnonymized = exports.isAllowed = exports.getIsDataAnonymizable = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getIsDataAnonymizable = rawData => typeof rawData !== 'string';
exports.getIsDataAnonymizable = getIsDataAnonymizable;
const isAllowed = ({
  allowSet,
  field
}) => allowSet.has(field);
exports.isAllowed = isAllowed;
const isDenied = ({
  allowSet,
  field
}) => !allowSet.has(field);
exports.isDenied = isDenied;
const isAnonymized = ({
  allowReplacementSet,
  field
}) => allowReplacementSet.has(field);
exports.isAnonymized = isAnonymized;